/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine;

import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.sql.engine.exec.TransactionalOperationTracker;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.impl.TransactionInflights;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.tx.TransactionException;

class InflightTransactionalOperationTracker
implements TransactionalOperationTracker {
    private final TransactionInflights delegate;

    InflightTransactionalOperationTracker(TransactionInflights delegate) {
        this.delegate = delegate;
    }

    @Override
    public void registerOperationStart(InternalTransaction tx) {
        if (InflightTransactionalOperationTracker.shouldBeTracked(tx)) {
            boolean result;
            boolean bl = result = tx.isReadOnly() ? this.delegate.addScanInflight(tx.id()) : this.delegate.track(tx.id());
            if (!result) {
                throw new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_ERR, IgniteStringFormatter.format("Transaction is already finished [tx={}]", tx));
            }
        }
    }

    @Override
    public void registerOperationFinish(InternalTransaction tx) {
        if (InflightTransactionalOperationTracker.shouldBeTracked(tx) && tx.isReadOnly()) {
            this.delegate.removeInflight(tx.id());
        }
    }

    private static boolean shouldBeTracked(InternalTransaction tx) {
        return !tx.implicit();
    }
}

