/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near.consistency;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.IgniteIrreparableConsistencyViolationException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.lang.IgniteInClosure;

public class GridCompoundReadRepairFuture
extends GridFutureAdapter<Void>
implements IgniteInClosure<IgniteInternalFuture<Void>> {
    private static final AtomicIntegerFieldUpdater<GridCompoundReadRepairFuture> LSNR_CALLS_UPD = AtomicIntegerFieldUpdater.newUpdater(GridCompoundReadRepairFuture.class, "lsnrCalls");
    private volatile boolean inited;
    private volatile int lsnrCalls;
    private volatile int size;
    private volatile Collection<Object> irreparableKeys;

    public void add(IgniteInternalFuture<Void> fut) {
        ++this.size;
        fut.listen(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IgniteInternalFuture<Void> fut) {
        Throwable e = fut.error();
        if (e != null) {
            if (e instanceof IgniteIrreparableConsistencyViolationException) {
                Collection<Object> repairableKey = ((IgniteIrreparableConsistencyViolationException)e).repairableKeys();
                Collection<Object> irreparableKeys = ((IgniteIrreparableConsistencyViolationException)e).irreparableKeys();
                assert (repairableKey == null || repairableKey.isEmpty()) : repairableKey.size();
                assert (irreparableKeys.size() == 1) : irreparableKeys.size();
                GridCompoundReadRepairFuture gridCompoundReadRepairFuture = this;
                synchronized (gridCompoundReadRepairFuture) {
                    if (this.irreparableKeys == null) {
                        this.irreparableKeys = ConcurrentHashMap.newKeySet();
                    }
                }
                this.irreparableKeys.addAll(irreparableKeys);
            } else {
                this.onDone(e);
            }
        }
        LSNR_CALLS_UPD.incrementAndGet(this);
        this.checkComplete();
    }

    public final void markInitialized() {
        this.inited = true;
        this.checkComplete();
    }

    private void checkComplete() {
        assert (this.lsnrCalls <= this.size);
        if (this.inited && !this.isDone() && this.lsnrCalls == this.size) {
            if (this.irreparableKeys == null) {
                this.onDone();
            } else {
                this.onDone(new IgniteIrreparableConsistencyViolationException(null, this.irreparableKeys));
            }
        }
    }
}

