/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.ignite.internal.util.GridSerializableMap;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.jetbrains.annotations.Nullable;

public class GridLeanMap<K, V>
extends GridSerializableMap<K, V>
implements Cloneable {
    private static final long serialVersionUID = 0L;
    private LeanMap<K, V> map;

    public GridLeanMap() {
        this(3);
    }

    public GridLeanMap(int size) {
        assert (size >= 0);
        this.map = size == 0 ? null : (size == 1 ? new Map1() : (size == 2 ? new Map2() : (size == 3 ? new Map3() : (size == 4 ? new Map4() : (size == 5 ? new Map5() : new LeanHashMap(IgniteUtils.capacity(size), 0.75f))))));
    }

    public GridLeanMap(Map<K, V> m) {
        this.buildFrom(m);
    }

    private void buildFrom(Map<K, V> m) {
        Iterator<Map.Entry<K, V>> iter = m.entrySet().iterator();
        if (m.isEmpty()) {
            this.map = null;
        } else if (m.size() == 1) {
            Map.Entry<K, V> e = iter.next();
            this.map = new Map1<K, V>(e.getKey(), e.getValue());
        } else if (m.size() == 2) {
            Map.Entry<K, V> e1 = iter.next();
            Map.Entry<K, V> e2 = iter.next();
            this.map = new Map2<K, V>(e1.getKey(), e1.getValue(), e2.getKey(), e2.getValue());
        } else if (m.size() == 3) {
            Map.Entry<K, V> e1 = iter.next();
            Map.Entry<K, V> e2 = iter.next();
            Map.Entry<K, V> e3 = iter.next();
            this.map = new Map3<K, V>(e1.getKey(), e1.getValue(), e2.getKey(), e2.getValue(), e3.getKey(), e3.getValue());
        } else if (m.size() == 4) {
            Map.Entry<K, V> e1 = iter.next();
            Map.Entry<K, V> e2 = iter.next();
            Map.Entry<K, V> e3 = iter.next();
            Map.Entry<K, V> e4 = iter.next();
            this.map = new Map4<K, V>(e1.getKey(), e1.getValue(), e2.getKey(), e2.getValue(), e3.getKey(), e3.getValue(), e4.getKey(), e4.getValue());
        } else if (m.size() == 5) {
            Map.Entry<K, V> e1 = iter.next();
            Map.Entry<K, V> e2 = iter.next();
            Map.Entry<K, V> e3 = iter.next();
            Map.Entry<K, V> e4 = iter.next();
            Map.Entry<K, V> e5 = iter.next();
            this.map = new Map5<K, V>(e1.getKey(), e1.getValue(), e2.getKey(), e2.getValue(), e3.getKey(), e3.getValue(), e4.getKey(), e4.getValue(), e5.getKey(), e5.getValue());
        } else {
            this.map = new LeanHashMap<K, V>(m);
        }
    }

    @Override
    public int size() {
        return this.map != null ? this.map.size() : 0;
    }

    @Override
    public boolean containsKey(Object key) {
        A.notNull(key, "key");
        return this.map != null && this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object val) {
        return this.map != null && this.map.containsValue(val);
    }

    @Override
    @Nullable
    public V get(Object key) {
        A.notNull(key, "key");
        return this.map != null ? (V)this.map.get(key) : null;
    }

    @Override
    @Nullable
    public V put(K key, V val) throws NullPointerException {
        A.notNull(key, "key");
        if (this.map == null) {
            this.map = new Map1<K, V>(key, val);
            return null;
        }
        if (!this.map.isFull() || this.map.containsKey(key)) {
            return this.map.put(key, val);
        }
        int size = this.map.size();
        if (size == 1) {
            Map1 m = (Map1)this.map;
            this.map = new Map2(m.k1, m.v1, key, val);
        } else if (size == 2) {
            Map2 m = (Map2)this.map;
            this.map = new Map3<Object, Object>(m.k1, m.v1, m.k2, m.v2, key, val);
        } else if (size == 3) {
            Map3 m = (Map3)this.map;
            this.map = new Map4<Object, Object>(m.k1, m.v1, m.k2, m.v2, m.k3, m.v3, key, val);
        } else if (size == 4) {
            Map4 m = (Map4)this.map;
            this.map = new Map5<Object, Object>(m.k1, m.v1, m.k2, m.v2, m.k3, m.v3, m.k4, m.v4, key, val);
        } else if (size == 5) {
            LeanMap<K, V> m = this.map;
            this.map = new LeanHashMap(6, 1.0f);
            this.map.putAll(m);
            this.map.put(key, val);
        } else {
            this.map.put(key, val);
        }
        return null;
    }

    @Override
    @Nullable
    public V remove(Object key) {
        A.notNull(key, "key");
        if (this.map instanceof LeanHashMap) {
            Object old = this.map.remove(key);
            if (this.map.size() > 5) {
                return old;
            }
            this.buildFrom(this.map);
            return old;
        }
        if (this.map == null) {
            return null;
        }
        int size = this.map.size();
        Object old = this.map.remove(key);
        if (this.map.size() < size) {
            this.buildFrom(this.map);
        }
        return old;
    }

    @Override
    public void clear() {
        this.map = null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    protected Object clone() {
        try {
            GridLeanMap clone = (GridLeanMap)super.clone();
            clone.buildFrom(this);
            return clone;
        }
        catch (CloneNotSupportedException ignore) {
            throw new InternalError();
        }
    }

    private static class LeanHashMap<K, V>
    extends HashMap<K, V>
    implements LeanMap<K, V> {
        private static final long serialVersionUID = 0L;

        private LeanHashMap(int initCap, float loadFactor) {
            super(initCap, loadFactor);
        }

        private LeanHashMap(Map<? extends K, ? extends V> m) {
            super(m);
        }

        @Override
        public boolean isFull() {
            return false;
        }
    }

    private static class Map5<K, V>
    extends Map4<K, V> {
        private static final long serialVersionUID = 0L;
        private K k5;
        private V v5;

        Map5() {
        }

        Map5(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
            super(k1, v1, k2, v2, k3, v3, k4, v4);
            this.k5 = k5;
            this.v5 = v5;
        }

        @Override
        public boolean isFull() {
            return this.size() == 5;
        }

        @Override
        @Nullable
        public V remove(Object key) {
            if (F.eq(key, this.k5)) {
                V res = this.v5;
                this.v5 = null;
                this.k5 = null;
                return res;
            }
            return super.remove(key);
        }

        @Override
        public int size() {
            return super.size() + (this.k5 != null ? 1 : 0);
        }

        @Override
        public boolean containsKey(Object k) {
            return super.containsKey(k) || this.k5 != null && F.eq(k, this.k5);
        }

        @Override
        public boolean containsValue(Object v) {
            return super.containsValue(v) || this.k5 != null && F.eq(v, this.v5);
        }

        @Override
        @Nullable
        public V get(Object k) {
            Object v = super.get(k);
            return (V)(v != null ? v : (this.k5 != null && F.eq(k, this.k5) ? this.v5 : null));
        }

        @Override
        @Nullable
        public V put(K key, V val) throws NullPointerException {
            V oldVal = this.get(key);
            if (this.k1 == null || F.eq(this.k1, key)) {
                this.k1 = key;
                this.v1 = val;
            } else if (this.k2 == null || F.eq(this.k2, key)) {
                this.k2 = key;
                this.v2 = val;
            } else if (this.k3 == null || F.eq(this.k3, key)) {
                this.k3 = key;
                this.v3 = val;
            } else if (this.k4 == null || F.eq(this.k4, key)) {
                this.k4 = key;
                this.v4 = val;
            } else if (this.k5 == null || F.eq(this.k5, key)) {
                this.k5 = key;
                this.v5 = val;
            }
            return oldVal;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private int idx;
                        private Map.Entry<K, V> next;
                        {
                            if (k1 != null) {
                                this.idx = 1;
                                this.next = this.e(k1, v1);
                            } else if (k2 != null) {
                                this.idx = 2;
                                this.next = this.e(k2, v2);
                            } else if (k3 != null) {
                                this.idx = 3;
                                this.next = this.e(k3, v3);
                            } else if (k4 != null) {
                                this.idx = 4;
                                this.next = this.e(k4, v4);
                            } else if (k5 != null) {
                                this.idx = 5;
                                this.next = this.e(k5, v5);
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            return this.next != null;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Map.Entry old = this.next;
                            this.next = null;
                            switch (this.idx) {
                                case 1: {
                                    if (k2 != null) {
                                        this.idx = 2;
                                        this.next = this.e(k2, v2);
                                        break;
                                    }
                                }
                                case 2: {
                                    if (k3 != null) {
                                        this.idx = 3;
                                        this.next = this.e(k3, v3);
                                        break;
                                    }
                                }
                                case 3: {
                                    if (k4 != null) {
                                        this.idx = 4;
                                        this.next = this.e(k4, v4);
                                        break;
                                    }
                                }
                                case 4: {
                                    if (k5 == null) break;
                                    this.idx = 5;
                                    this.next = this.e(k5, v5);
                                }
                            }
                            return old;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return this.size();
                }
            };
        }
    }

    private static class Map4<K, V>
    extends Map3<K, V> {
        private static final long serialVersionUID = 0L;
        protected K k4;
        protected V v4;

        Map4() {
        }

        Map4(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
            super(k1, v1, k2, v2, k3, v3);
            this.k4 = k4;
            this.v4 = v4;
        }

        @Override
        public boolean isFull() {
            return this.size() == 4;
        }

        @Override
        @Nullable
        public V remove(Object key) {
            if (F.eq(key, this.k4)) {
                V res = this.v4;
                this.v4 = null;
                this.k4 = null;
                return res;
            }
            return super.remove(key);
        }

        @Override
        public int size() {
            return super.size() + (this.k4 != null ? 1 : 0);
        }

        @Override
        public boolean containsKey(Object k) {
            return super.containsKey(k) || this.k4 != null && F.eq(k, this.k4);
        }

        @Override
        public boolean containsValue(Object v) {
            return super.containsValue(v) || this.k4 != null && F.eq(v, this.v4);
        }

        @Override
        @Nullable
        public V get(Object k) {
            Object v = super.get(k);
            return (V)(v != null ? v : (this.k4 != null && F.eq(k, this.k4) ? this.v4 : null));
        }

        @Override
        @Nullable
        public V put(K key, V val) throws NullPointerException {
            V oldVal = this.get(key);
            if (this.k1 == null || F.eq(this.k1, key)) {
                this.k1 = key;
                this.v1 = val;
            } else if (this.k2 == null || F.eq(this.k2, key)) {
                this.k2 = key;
                this.v2 = val;
            } else if (this.k3 == null || F.eq(this.k3, key)) {
                this.k3 = key;
                this.v3 = val;
            } else if (this.k4 == null || F.eq(this.k4, key)) {
                this.k4 = key;
                this.v4 = val;
            }
            return oldVal;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private int idx;
                        private Map.Entry<K, V> next;
                        {
                            if (k1 != null) {
                                this.idx = 1;
                                this.next = this.e(k1, v1);
                            } else if (k2 != null) {
                                this.idx = 2;
                                this.next = this.e(k2, v2);
                            } else if (k3 != null) {
                                this.idx = 3;
                                this.next = this.e(k3, v3);
                            } else if (k4 != null) {
                                this.idx = 4;
                                this.next = this.e(k4, v4);
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            return this.next != null;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Map.Entry old = this.next;
                            this.next = null;
                            switch (this.idx) {
                                case 1: {
                                    if (k2 != null) {
                                        this.idx = 2;
                                        this.next = this.e(k2, v2);
                                        break;
                                    }
                                }
                                case 2: {
                                    if (k3 != null) {
                                        this.idx = 3;
                                        this.next = this.e(k3, v3);
                                        break;
                                    }
                                }
                                case 3: {
                                    if (k4 == null) break;
                                    this.idx = 4;
                                    this.next = this.e(k4, v4);
                                }
                            }
                            return old;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return this.size();
                }
            };
        }
    }

    private static class Map3<K, V>
    extends Map2<K, V> {
        private static final long serialVersionUID = 0L;
        protected K k3;
        protected V v3;

        Map3() {
        }

        Map3(K k1, V v1, K k2, V v2, K k3, V v3) {
            super(k1, v1, k2, v2);
            this.k3 = k3;
            this.v3 = v3;
        }

        @Override
        public boolean isFull() {
            return this.size() == 3;
        }

        @Override
        @Nullable
        public V remove(Object key) {
            if (F.eq(key, this.k3)) {
                V res = this.v3;
                this.v3 = null;
                this.k3 = null;
                return res;
            }
            return super.remove(key);
        }

        @Override
        public int size() {
            return super.size() + (this.k3 != null ? 1 : 0);
        }

        @Override
        public boolean containsKey(Object k) {
            return super.containsKey(k) || this.k3 != null && F.eq(k, this.k3);
        }

        @Override
        public boolean containsValue(Object v) {
            return super.containsValue(v) || this.k3 != null && F.eq(v, this.v3);
        }

        @Override
        @Nullable
        public V get(Object k) {
            Object v = super.get(k);
            return (V)(v != null ? v : (this.k3 != null && F.eq(k, this.k3) ? this.v3 : null));
        }

        @Override
        @Nullable
        public V put(K key, V val) throws NullPointerException {
            V oldVal = this.get(key);
            if (this.k1 == null || F.eq(this.k1, key)) {
                this.k1 = key;
                this.v1 = val;
            } else if (this.k2 == null || F.eq(this.k2, key)) {
                this.k2 = key;
                this.v2 = val;
            } else if (this.k3 == null || F.eq(this.k3, key)) {
                this.k3 = key;
                this.v3 = val;
            }
            return oldVal;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private int idx;
                        private Map.Entry<K, V> next;
                        {
                            if (k1 != null) {
                                this.idx = 1;
                                this.next = this.e(k1, v1);
                            } else if (k2 != null) {
                                this.idx = 2;
                                this.next = this.e(k2, v2);
                            } else if (k3 != null) {
                                this.idx = 3;
                                this.next = this.e(k3, v3);
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            return this.next != null;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Map.Entry old = this.next;
                            this.next = null;
                            switch (this.idx) {
                                case 1: {
                                    if (k2 != null) {
                                        this.idx = 2;
                                        this.next = this.e(k2, v2);
                                        break;
                                    }
                                }
                                case 2: {
                                    if (k3 == null) break;
                                    this.idx = 3;
                                    this.next = this.e(k3, v3);
                                }
                            }
                            return old;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return this.size();
                }
            };
        }
    }

    private static class Map2<K, V>
    extends Map1<K, V> {
        private static final long serialVersionUID = 0L;
        protected K k2;
        protected V v2;

        Map2() {
        }

        Map2(K k1, V v1, K k2, V v2) {
            super(k1, v1);
            this.k2 = k2;
            this.v2 = v2;
        }

        @Override
        public boolean isFull() {
            return this.size() == 2;
        }

        @Override
        @Nullable
        public V remove(Object key) {
            if (F.eq(key, this.k2)) {
                V res = this.v2;
                this.v2 = null;
                this.k2 = null;
                return res;
            }
            return super.remove(key);
        }

        @Override
        public int size() {
            return super.size() + (this.k2 != null ? 1 : 0);
        }

        @Override
        public boolean containsKey(Object k) {
            return super.containsKey(k) || this.k2 != null && F.eq(k, this.k2);
        }

        @Override
        public boolean containsValue(Object v) {
            return super.containsValue(v) || this.k2 != null && F.eq(v, this.v2);
        }

        @Override
        public V get(Object k) {
            Object v = super.get(k);
            return (V)(v != null ? v : (this.k2 != null && F.eq(k, this.k2) ? this.v2 : null));
        }

        @Override
        @Nullable
        public V put(K key, V val) throws NullPointerException {
            V oldVal = this.get(key);
            if (this.k1 == null || F.eq(this.k1, key)) {
                this.k1 = key;
                this.v1 = val;
            } else if (this.k2 == null || F.eq(this.k2, key)) {
                this.k2 = key;
                this.v2 = val;
            }
            return oldVal;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private int idx;
                        private Map.Entry<K, V> next;
                        {
                            if (k1 != null) {
                                this.idx = 1;
                                this.next = this.e(k1, v1);
                            } else if (k2 != null) {
                                this.idx = 2;
                                this.next = this.e(k2, v2);
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            return this.next != null;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Map.Entry old = this.next;
                            this.next = null;
                            if (this.idx == 1 && k2 != null) {
                                this.idx = 2;
                                this.next = this.e(k2, v2);
                            }
                            return old;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return this.size();
                }
            };
        }
    }

    private static class Map1<K, V>
    extends AbstractMap<K, V>
    implements LeanMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 0L;
        protected K k1;
        protected V v1;

        Map1() {
        }

        Map1(K k1, V v1) {
            this.k1 = k1;
            this.v1 = v1;
        }

        @Override
        public boolean isFull() {
            return this.size() == 1;
        }

        @Override
        @Nullable
        public V remove(Object key) {
            V res = null;
            if (F.eq(key, this.k1)) {
                res = this.v1;
                this.v1 = null;
                this.k1 = null;
            }
            return res;
        }

        @Override
        public int size() {
            return this.k1 != null ? 1 : 0;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.k1 != null && F.eq(key, this.k1);
        }

        @Override
        public boolean containsValue(Object val) {
            return this.k1 != null && F.eq(val, this.v1);
        }

        @Override
        @Nullable
        public V get(Object key) {
            return this.k1 != null && F.eq(key, this.k1) ? (V)this.v1 : null;
        }

        @Override
        @Nullable
        public V put(K key, V val) {
            V oldVal = this.get(key);
            if (this.k1 == null || F.eq(this.k1, key)) {
                this.k1 = key;
                this.v1 = val;
            }
            return oldVal;
        }

        protected Map.Entry<K, V> e(K key, V val) {
            return new AbstractMap.SimpleImmutableEntry<K, V>(key, val);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private int idx;

                        @Override
                        public boolean hasNext() {
                            return this.idx == 0 && k1 != null;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            this.idx = 1;
                            return this.e(k1, v1);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return this.size();
                }
            };
        }
    }

    private static interface LeanMap<K, V>
    extends Map<K, V> {
        public boolean isFull();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private int idx = -1;
                private Iterator<Map.Entry<K, V>> mapIter;
                private Map.Entry<K, V> curEnt;

                private Iterator<Map.Entry<K, V>> getMapIterator(boolean forceNew) {
                    if (this.mapIter == null || forceNew) {
                        this.mapIter = GridLeanMap.this.map != null ? GridLeanMap.this.map.entrySet().iterator() : new Iterator<Map.Entry<K, V>>(){

                            @Override
                            public boolean hasNext() {
                                return false;
                            }

                            @Override
                            public Map.Entry<K, V> next() {
                                throw new NoSuchElementException();
                            }

                            @Override
                            public void remove() {
                                throw new IllegalStateException();
                            }
                        };
                    }
                    return this.mapIter;
                }

                @Override
                public boolean hasNext() {
                    return GridLeanMap.this.map != null && this.getMapIterator(false).hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ++this.idx;
                    this.curEnt = this.getMapIterator(false).next();
                    return this.curEnt;
                }

                @Override
                public void remove() {
                    if (this.curEnt == null) {
                        throw new IllegalStateException();
                    }
                    GridLeanMap.this.remove(this.curEnt.getKey());
                    this.curEnt = null;
                    this.mapIter = this.getMapIterator(true);
                    for (int i = 0; i < this.idx && this.mapIter.hasNext(); ++i) {
                        this.mapIter.next();
                    }
                    --this.idx;
                }
            };
        }

        @Override
        public int size() {
            return GridLeanMap.this.size();
        }
    }
}

