/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sessiondict.client;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.MoreExecutors;
import io.reactivex.rxjava3.core.Observable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.baserpc.client.IConnectable;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.sessiondict.SessionRegisterKeyUtil;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.apache.bifromq.sessiondict.client.ISessionRegistration;
import org.apache.bifromq.sessiondict.client.SessionRegister;
import org.apache.bifromq.sessiondict.client.SessionRegistration;
import org.apache.bifromq.sessiondict.client.scheduler.IOnlineCheckScheduler;
import org.apache.bifromq.sessiondict.client.scheduler.OnlineCheckScheduler;
import org.apache.bifromq.sessiondict.client.type.OnlineCheckRequest;
import org.apache.bifromq.sessiondict.client.type.OnlineCheckResult;
import org.apache.bifromq.sessiondict.rpc.proto.GetInboxStateReply;
import org.apache.bifromq.sessiondict.rpc.proto.GetInboxStateRequest;
import org.apache.bifromq.sessiondict.rpc.proto.GetReply;
import org.apache.bifromq.sessiondict.rpc.proto.GetRequest;
import org.apache.bifromq.sessiondict.rpc.proto.KillAllReply;
import org.apache.bifromq.sessiondict.rpc.proto.KillAllRequest;
import org.apache.bifromq.sessiondict.rpc.proto.KillReply;
import org.apache.bifromq.sessiondict.rpc.proto.KillRequest;
import org.apache.bifromq.sessiondict.rpc.proto.ServerRedirection;
import org.apache.bifromq.sessiondict.rpc.proto.SessionDictServiceGrpc;
import org.apache.bifromq.sessiondict.rpc.proto.SubReply;
import org.apache.bifromq.sessiondict.rpc.proto.SubRequest;
import org.apache.bifromq.sessiondict.rpc.proto.UnsubReply;
import org.apache.bifromq.sessiondict.rpc.proto.UnsubRequest;
import org.apache.bifromq.type.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SessionDictClient
implements ISessionDictClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionDictClient.class);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final IRPCClient rpcClient;
    private final IOnlineCheckScheduler sessionExistScheduler;
    private final LoadingCache<ManagerCacheKey, SessionRegister> tenantSessionRegisterManagers;

    SessionDictClient(IRPCClient rpcClient) {
        this.rpcClient = rpcClient;
        this.sessionExistScheduler = new OnlineCheckScheduler(rpcClient);
        this.tenantSessionRegisterManagers = Caffeine.newBuilder().weakValues().executor(MoreExecutors.directExecutor()).build(key -> new SessionRegister(key.tenantId, key.registerKey, rpcClient));
    }

    public Observable<IConnectable.ConnState> connState() {
        return this.rpcClient.connState();
    }

    @Override
    public ISessionRegistration reg(ClientInfo owner, ISessionDictClient.IKillListener killListener) {
        return new SessionRegistration(owner, killListener, (SessionRegister)this.tenantSessionRegisterManagers.get((Object)new ManagerCacheKey(owner.getTenantId(), SessionRegisterKeyUtil.toRegisterKey((ClientInfo)owner))));
    }

    @Override
    public CompletableFuture<KillReply> kill(long reqId, String tenantId, String userId, String clientId, ClientInfo killer, ServerRedirection redirection) {
        return this.rpcClient.invoke(tenantId, null, (Object)KillRequest.newBuilder().setReqId(reqId).setTenantId(tenantId).setUserId(userId).setClientId(clientId).setKiller(killer).setServerRedirection(redirection).build(), SessionDictServiceGrpc.getKillMethod()).exceptionally(e -> KillReply.newBuilder().setReqId(reqId).setResult(KillReply.Result.ERROR).build());
    }

    @Override
    public CompletableFuture<KillAllReply> killAll(long reqId, String tenantId, String userId, ClientInfo killer, ServerRedirection redirection) {
        KillAllRequest.Builder reqBuilder = KillAllRequest.newBuilder().setReqId(reqId).setTenantId(tenantId).setKiller(killer).setServerRedirection(redirection);
        if (!Strings.isNullOrEmpty((String)userId)) {
            reqBuilder.setUserId(userId);
        }
        return (CompletableFuture)this.rpcClient.serverList().firstElement().map(Map::keySet).toCompletionStage().thenApply(servers -> servers.stream().map(serverId -> this.rpcClient.invoke(tenantId, serverId, (Object)reqBuilder.build(), SessionDictServiceGrpc.getKillAllMethod())).toList()).thenCompose(killAllFutures -> CompletableFuture.allOf((CompletableFuture[])killAllFutures.toArray(CompletableFuture[]::new)).thenApply(v -> killAllFutures.stream().map(CompletableFuture::join).toList())).thenApply(killAllReplies -> {
            if (killAllReplies.stream().allMatch(reply -> reply.getResult() == KillAllReply.Result.OK)) {
                return KillAllReply.newBuilder().setReqId(reqId).setResult(KillAllReply.Result.OK).build();
            }
            return KillAllReply.newBuilder().setReqId(reqId).setResult(KillAllReply.Result.ERROR).build();
        }).exceptionally(e -> {
            log.debug("Failed to handle KillAllRequest", e);
            return KillAllReply.newBuilder().setReqId(reqId).setResult(KillAllReply.Result.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<GetReply> get(GetRequest request) {
        return this.rpcClient.invoke(request.getTenantId(), null, (Object)request, SessionDictServiceGrpc.getGetMethod()).exceptionally(e -> {
            log.debug("Failed to handle GetRequest", e);
            return GetReply.newBuilder().setReqId(request.getReqId()).setResult(GetReply.Result.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<OnlineCheckResult> exist(OnlineCheckRequest clientId) {
        return this.sessionExistScheduler.schedule(clientId);
    }

    @Override
    public CompletableFuture<GetInboxStateReply> inboxState(GetInboxStateRequest request) {
        return this.rpcClient.invoke(request.getTenantId(), null, (Object)request, SessionDictServiceGrpc.getInboxStateMethod()).exceptionally(e -> {
            log.debug("Failed to handle InboxStateRequest", e);
            return GetInboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(GetInboxStateReply.Code.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<SubReply> sub(SubRequest request) {
        return this.rpcClient.invoke(request.getTenantId(), null, (Object)request, SessionDictServiceGrpc.getSubMethod()).exceptionally(e -> {
            log.debug("Sub failed", e);
            return SubReply.newBuilder().setReqId(request.getReqId()).setResult(SubReply.Result.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<UnsubReply> unsub(UnsubRequest request) {
        return this.rpcClient.invoke(request.getTenantId(), null, (Object)request, SessionDictServiceGrpc.getUnsubMethod()).exceptionally(e -> {
            log.debug("Unsub failed", e);
            return UnsubReply.newBuilder().setReqId(request.getReqId()).setResult(UnsubReply.Result.ERROR).build();
        });
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            log.debug("Stopping session dict client");
            this.tenantSessionRegisterManagers.asMap().forEach((k, v) -> v.close());
            this.tenantSessionRegisterManagers.invalidateAll();
            this.sessionExistScheduler.close();
            log.debug("Stopping rpc client");
            this.rpcClient.stop();
            log.debug("Session dict client stopped");
        }
    }

    private record ManagerCacheKey(String tenantId, String registerKey) {
    }
}

