/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.record;

import io.netty.handler.codec.mqtt.MqttMessage;
import org.apache.bifromq.plugin.eventcollector.Event;

public record ProtocolResponse(MqttMessage message, Action action, Event<?>[] reasons) {
    public static ProtocolResponse responseNothing(Event<?> ... reasons) {
        return new ProtocolResponse(null, Action.NoResponse, reasons);
    }

    public static ProtocolResponse response(MqttMessage message, Event<?> ... reasons) {
        return new ProtocolResponse(message, Action.Response, reasons);
    }

    public static ProtocolResponse goAway(Event<?> ... reasons) {
        return new ProtocolResponse(null, Action.GoAway, reasons);
    }

    public static ProtocolResponse goAwayNow(Event<?> ... reasons) {
        return new ProtocolResponse(null, Action.GoAwayNow, reasons);
    }

    public static ProtocolResponse farewell(MqttMessage farewell, Event<?> ... reasons) {
        return new ProtocolResponse(farewell, Action.ResponseAndGoAway, reasons);
    }

    public static ProtocolResponse farewellNow(MqttMessage farewell, Event<?> ... reasons) {
        return new ProtocolResponse(farewell, Action.ResponseAndGoAwayNow, reasons);
    }

    public static enum Action {
        NoResponse,
        Response,
        GoAway,
        GoAwayNow,
        ResponseAndGoAway,
        ResponseAndGoAwayNow;

    }
}

