/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server.recovery;

import java.io.IOException;
import java.io.Serializable;
import org.apache.livy.LivyConf;
import org.apache.livy.Logging;
import org.apache.livy.server.recovery.SessionManagerState;
import org.apache.livy.server.recovery.SessionStore$;
import org.apache.livy.server.recovery.StateStore;
import org.apache.livy.sessions.Session;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001\u0002\n\u0014\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t[\u0001\u0011\t\u0011*A\u0005]!)Q\u0007\u0001C\u0001m!9!\b\u0001b\u0001\n\u0013Y\u0004BB$\u0001A\u0003%A\bC\u0003I\u0001\u0011\u0005\u0011\nC\u0003c\u0001\u0011\u00051\rC\u0003k\u0001\u0011\u00051\u000eC\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u00111\u0006\u0001\u0005\n\u00055\u0002bBA\u0019\u0001\u0011%\u00111\u0007\u0005\b\u0003c\u0001A\u0011BA\u001c\u000f%\tidEA\u0001\u0012\u0003\tyD\u0002\u0005\u0013'\u0005\u0005\t\u0012AA!\u0011\u0019)t\u0002\"\u0001\u0002D!I\u0011QI\b\u0012\u0002\u0013\u0005\u0011q\t\u0002\r'\u0016\u001c8/[8o'R|'/\u001a\u0006\u0003)U\t\u0001B]3d_Z,'/\u001f\u0006\u0003-]\taa]3sm\u0016\u0014(B\u0001\r\u001a\u0003\u0011a\u0017N^=\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019:S\"A\f\n\u0005!:\"a\u0002'pO\u001eLgnZ\u0001\tY&4\u0018pQ8oMB\u0011aeK\u0005\u0003Y]\u0011\u0001\u0002T5ws\u000e{gNZ\u0001\u0006gR|'/\u001a\t\u0004A=\n\u0014B\u0001\u0019\"\u0005!a$-\u001f8b[\u0016t\u0004C\u0001\u001a4\u001b\u0005\u0019\u0012B\u0001\u001b\u0014\u0005)\u0019F/\u0019;f'R|'/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007]B\u0014\b\u0005\u00023\u0001!)\u0011f\u0001a\u0001U!9Qf\u0001I\u0005\u0002\u0004q\u0013!D*U\u001fJ+uLV#S'&{e*F\u0001=!\tiDI\u0004\u0002?\u0005B\u0011q(I\u0007\u0002\u0001*\u0011\u0011)H\u0001\u0007yI|w\u000e\u001e \n\u0005\r\u000b\u0013A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!aQ\u0011\u0002\u001dM#vJU#`-\u0016\u00136+S(OA\u0005!1/\u0019<f)\rQUj\u0014\t\u0003A-K!\u0001T\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001d\u001a\u0001\r\u0001P\u0001\fg\u0016\u001c8/[8o)f\u0004X\rC\u0003Q\r\u0001\u0007\u0011+A\u0001n!\t\u0011vL\u0004\u0002T9:\u0011AK\u0017\b\u0003+fs!A\u0016-\u000f\u0005}:\u0016\"\u0001\u000f\n\u0005iY\u0012B\u0001\r\u001a\u0013\tYv#\u0001\u0005tKN\u001c\u0018n\u001c8t\u0013\tif,A\u0004TKN\u001c\u0018n\u001c8\u000b\u0005m;\u0012B\u00011b\u0005A\u0011VmY8wKJLX*\u001a;bI\u0006$\u0018M\u0003\u0002^=\u0006\t2/\u0019<f\u001d\u0016DHoU3tg&|g.\u00133\u0015\u0007)#W\rC\u0003O\u000f\u0001\u0007A\bC\u0003g\u000f\u0001\u0007q-\u0001\u0002jIB\u0011\u0001\u0005[\u0005\u0003S\u0006\u00121!\u00138u\u000399W\r^!mYN+7o]5p]N,\"\u0001\\@\u0015\u00075\fY\u0002F\u0002o\u0003\u0017\u00012a\u001c;x\u001d\t\u0001(O\u0004\u0002@c&\t!%\u0003\u0002tC\u00059\u0001/Y2lC\u001e,\u0017BA;w\u0005\r\u0019V-\u001d\u0006\u0003g\u0006\u00022\u0001_>~\u001b\u0005I(B\u0001>\"\u0003\u0011)H/\u001b7\n\u0005qL(a\u0001+ssB\u0011ap \u0007\u0001\t\u001d\t\t\u0001\u0003b\u0001\u0003\u0007\u0011\u0011\u0001V\t\u0004\u0003\u000b\t\u0006c\u0001\u0011\u0002\b%\u0019\u0011\u0011B\u0011\u0003\u000f9{G\u000f[5oO\"I\u0011Q\u0002\u0005\u0002\u0002\u0003\u000f\u0011qB\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004#BA\t\u0003/iXBAA\n\u0015\r\t)\"I\u0001\be\u00164G.Z2u\u0013\u0011\tI\"a\u0005\u0003\u0011\rc\u0017m]:UC\u001eDQA\u0014\u0005A\u0002q\n\u0001cZ3u\u001d\u0016DHoU3tg&|g.\u00133\u0015\u0007\u001d\f\t\u0003C\u0003O\u0013\u0001\u0007A(\u0001\u0004sK6|g/\u001a\u000b\u0006\u0015\u0006\u001d\u0012\u0011\u0006\u0005\u0006\u001d*\u0001\r\u0001\u0010\u0005\u0006M*\u0001\raZ\u0001\u0013g\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s!\u0006$\b\u000eF\u0002=\u0003_AQAT\u0006A\u0002q\n1b]3tg&|g\u000eU1uQR\u0019A(!\u000e\t\u000b9c\u0001\u0019\u0001\u001f\u0015\u000bq\nI$a\u000f\t\u000b9k\u0001\u0019\u0001\u001f\t\u000b\u0019l\u0001\u0019A4\u0002\u0019M+7o]5p]N#xN]3\u0011\u0005Iz1CA\b )\t\ty$A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0013R3!MA&W\t\ti\u0005\u0005\u0003\u0002P\u0005eSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\u0013Ut7\r[3dW\u0016$'bAA,C\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0013\u0011\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class SessionStore
implements Logging {
    private final Function0<StateStore> store;
    private final String STORE_VERSION;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static StateStore $lessinit$greater$default$2() {
        return SessionStore$.MODULE$.$lessinit$greater$default$2();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        SessionStore sessionStore = this;
        synchronized (sessionStore) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String STORE_VERSION() {
        return this.STORE_VERSION;
    }

    public void save(String sessionType, Session.RecoveryMetadata m) {
        ((StateStore)this.store.apply()).set(this.sessionPath(sessionType, m.id()), m);
    }

    public void saveNextSessionId(String sessionType, int id) {
        ((StateStore)this.store.apply()).set(this.sessionManagerPath(sessionType), new SessionManagerState(id));
    }

    public <T extends Session.RecoveryMetadata> Seq<Try<T>> getAllSessions(String sessionType, ClassTag<T> evidence$1) {
        return (Seq)((TraversableLike)((StateStore)this.store.apply()).getChildren(this.sessionPath(sessionType)).flatMap((Function1 & Serializable & scala.Serializable)c -> Option$.MODULE$.option2Iterable(Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(c)).toInt()).toOption()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)id -> SessionStore.$anonfun$getAllSessions$3(this, sessionType, evidence$1, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom());
    }

    public int getNextSessionId(String sessionType) {
        return BoxesRunTime.unboxToInt((Object)((StateStore)this.store.apply()).get(this.sessionManagerPath(sessionType), ClassTag$.MODULE$.apply(SessionManagerState.class)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.nextSessionId())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public void remove(String sessionType, int id) {
        ((StateStore)this.store.apply()).remove(this.sessionPath(sessionType, id));
    }

    private String sessionManagerPath(String sessionType) {
        return new StringBuilder(7).append(this.STORE_VERSION()).append("/").append(sessionType).append("/state").toString();
    }

    private String sessionPath(String sessionType) {
        return new StringBuilder(1).append(this.STORE_VERSION()).append("/").append(sessionType).toString();
    }

    private String sessionPath(String sessionType, int id) {
        return new StringBuilder(2).append(this.STORE_VERSION()).append("/").append(sessionType).append("/").append(id).toString();
    }

    public static final /* synthetic */ Iterable $anonfun$getAllSessions$3(SessionStore $this, String sessionType$1, ClassTag evidence$1$1, int id) {
        Iterable iterable;
        String p = $this.sessionPath(sessionType$1, id);
        try {
            iterable = Option$.MODULE$.option2Iterable(((StateStore)$this.store.apply()).get(p, evidence$1$1).map((Function1 & Serializable & scala.Serializable)x$1 -> new Success(x$1)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Failure((Throwable)new IOException(new StringBuilder(22).append("Error getting session ").append(p).toString(), e))));
            }
            throw throwable;
        }
        return iterable;
    }

    public SessionStore(LivyConf livyConf, Function0<StateStore> store) {
        this.store = store;
        Logging.$init$((Logging)this);
        this.STORE_VERSION = "v1";
    }
}

