/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.AccessibleByteArrayOutputStream;
import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.implementation.ReflectiveInvoker;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;

public final class ReflectionSerializable {
    private static final ClientLogger LOGGER = new ClientLogger(ReflectionSerializable.class);
    private static final Map<Class<?>, ReflectiveInvoker> FROM_JSON_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, ReflectiveInvoker> FROM_XML_CACHE = new ConcurrentHashMap();

    public static boolean supportsJsonSerializable(Class<?> bodyContentClass) {
        if (FROM_JSON_CACHE.containsKey(bodyContentClass)) {
            return true;
        }
        if (!JsonSerializable.class.isAssignableFrom(bodyContentClass)) {
            return false;
        }
        boolean hasFromJson = false;
        boolean hasToJson = false;
        for (Method method : bodyContentClass.getDeclaredMethods()) {
            if (method.getName().equals("fromJson") && (method.getModifiers() & 8) != 0 && method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(JsonReader.class)) {
                hasFromJson = true;
            } else if (method.getName().equals("toJson") && method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(JsonWriter.class)) {
                hasToJson = true;
            }
            if (!hasFromJson || !hasToJson) continue;
            return true;
        }
        return false;
    }

    public static ByteBuffer serializeJsonSerializableToByteBuffer(JsonSerializable<?> jsonSerializable) throws IOException {
        return ReflectionSerializable.serializeJsonSerializableWithReturn(jsonSerializable, AccessibleByteArrayOutputStream::toByteBuffer);
    }

    public static byte[] serializeJsonSerializableToBytes(JsonSerializable<?> jsonSerializable) throws IOException {
        return ReflectionSerializable.serializeJsonSerializableWithReturn(jsonSerializable, AccessibleByteArrayOutputStream::toByteArray);
    }

    public static String serializeJsonSerializableToString(JsonSerializable<?> jsonSerializable) throws IOException {
        return ReflectionSerializable.serializeJsonSerializableWithReturn(jsonSerializable, aos -> aos.toString(StandardCharsets.UTF_8));
    }

    private static <T> T serializeJsonSerializableWithReturn(JsonSerializable<?> jsonSerializable, Function<AccessibleByteArrayOutputStream, T> returner) throws IOException {
        AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream();
        jsonSerializable.toJson((OutputStream)outputStream);
        return returner.apply(outputStream);
    }

    public static void serializeJsonSerializableIntoOutputStream(JsonSerializable<?> jsonSerializable, OutputStream outputStream) throws IOException {
        jsonSerializable.toJson(outputStream);
    }

    public static Object deserializeAsJsonSerializable(Class<?> jsonSerializable, byte[] json) throws IOException {
        Object object;
        block11: {
            if (FROM_JSON_CACHE.size() >= 10000) {
                FROM_JSON_CACHE.clear();
            }
            ReflectiveInvoker readJson = FROM_JSON_CACHE.computeIfAbsent(jsonSerializable, clazz -> {
                try {
                    return ReflectionUtils.getMethodInvoker(clazz, jsonSerializable.getDeclaredMethod("fromJson", JsonReader.class));
                }
                catch (Exception e) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException(e));
                }
            });
            JsonReader jsonReader = JsonProviders.createReader((byte[])json);
            try {
                object = readJson.invokeStatic(jsonReader);
                if (jsonReader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof Exception) {
                        throw new IOException(e);
                    }
                    throw (Error)e;
                }
            }
            jsonReader.close();
        }
        return object;
    }

    public static boolean supportsXmlSerializable(Class<?> bodyContentClass) {
        if (FROM_XML_CACHE.containsKey(bodyContentClass)) {
            return true;
        }
        if (!XmlSerializable.class.isAssignableFrom(bodyContentClass)) {
            return false;
        }
        boolean hasFromXml = false;
        boolean hasToXml = false;
        for (Method method : bodyContentClass.getDeclaredMethods()) {
            if (method.getName().equals("fromXml") && (method.getModifiers() & 8) != 0 && method.getParameterCount() == 2 && method.getParameterTypes()[0].equals(XmlReader.class) && method.getParameterTypes()[1].equals(String.class)) {
                hasFromXml = true;
            } else if (method.getName().equals("toXml") && method.getParameterCount() == 2 && method.getParameterTypes()[0].equals(XmlWriter.class) && method.getParameterTypes()[1].equals(String.class)) {
                hasToXml = true;
            }
            if (!hasFromXml || !hasToXml) continue;
            return true;
        }
        return false;
    }

    public static ByteBuffer serializeXmlSerializableToByteBuffer(XmlSerializable<?> xmlSerializable) throws IOException {
        return ReflectionSerializable.serializeXmlSerializableWithReturn(xmlSerializable, AccessibleByteArrayOutputStream::toByteBuffer);
    }

    public static byte[] serializeXmlSerializableToBytes(XmlSerializable<?> xmlSerializable) throws IOException {
        return ReflectionSerializable.serializeXmlSerializableWithReturn(xmlSerializable, AccessibleByteArrayOutputStream::toByteArray);
    }

    public static String serializeXmlSerializableToString(XmlSerializable<?> xmlSerializable) throws IOException {
        return ReflectionSerializable.serializeXmlSerializableWithReturn(xmlSerializable, aos -> aos.toString(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static <T> T serializeXmlSerializableWithReturn(XmlSerializable<?> xmlSerializable, Function<AccessibleByteArrayOutputStream, T> returner) throws IOException {
        try (AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream();){
            AccessibleByteArrayOutputStream accessibleByteArrayOutputStream;
            block13: {
                XmlWriter xmlWriter = XmlWriter.toStream((OutputStream)outputStream);
                try {
                    xmlWriter.writeStartDocument();
                    xmlWriter.writeXml(xmlSerializable);
                    xmlWriter.flush();
                    accessibleByteArrayOutputStream = returner.apply(outputStream);
                    if (xmlWriter == null) break block13;
                }
                catch (Throwable throwable) {
                    if (xmlWriter != null) {
                        try {
                            xmlWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                xmlWriter.close();
            }
            return (T)accessibleByteArrayOutputStream;
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    public static void serializeXmlSerializableIntoOutputStream(XmlSerializable<?> xmlSerializable, OutputStream outputStream) throws IOException {
        try (XmlWriter xmlWriter = XmlWriter.toStream((OutputStream)outputStream);){
            xmlWriter.writeStartDocument();
            xmlWriter.writeXml(xmlSerializable);
            xmlWriter.flush();
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    public static Object deserializeAsXmlSerializable(Class<?> xmlSerializable, byte[] xml) throws IOException {
        Object object;
        block11: {
            if (FROM_XML_CACHE.size() >= 10000) {
                FROM_XML_CACHE.clear();
            }
            ReflectiveInvoker readXml = FROM_XML_CACHE.computeIfAbsent(xmlSerializable, clazz -> {
                try {
                    return ReflectionUtils.getMethodInvoker(xmlSerializable, xmlSerializable.getDeclaredMethod("fromXml", XmlReader.class));
                }
                catch (Exception e) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException(e));
                }
            });
            XmlReader xmlReader = XmlReader.fromBytes((byte[])xml);
            try {
                object = readXml.invokeStatic(xmlReader);
                if (xmlReader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (xmlReader != null) {
                        try {
                            xmlReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof Exception) {
                        throw new IOException(e);
                    }
                    throw (Error)e;
                }
            }
            xmlReader.close();
        }
        return object;
    }

    private ReflectionSerializable() {
    }
}

