/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdToken;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.RefreshToken;
import io.quarkus.oidc.TokenIntrospection;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import org.jboss.logging.Logger;

@RequestScoped
public class OidcTokenCredentialProducer {
    private static final Logger LOG = Logger.getLogger(OidcTokenCredentialProducer.class);
    @Inject
    SecurityIdentity identity;

    @Produces
    @RequestScoped
    IdTokenCredential currentIdToken() {
        IdTokenCredential cred = OidcUtils.getTokenCredential(this.identity, IdTokenCredential.class);
        if (cred == null || cred.getToken() == null) {
            LOG.trace((Object)"IdToken is null");
            cred = new IdTokenCredential();
        }
        return cred;
    }

    @Produces
    @RequestScoped
    @Alternative
    @Priority(value=1)
    AccessTokenCredential currentAccessToken() {
        AccessTokenCredential cred = OidcUtils.getTokenCredential(this.identity, AccessTokenCredential.class);
        if (cred == null || cred.getToken() == null) {
            LOG.trace((Object)"AccessToken is null");
            cred = new AccessTokenCredential();
        }
        return cred;
    }

    @Produces
    @RequestScoped
    RefreshToken currentRefreshToken() {
        RefreshToken cred = OidcUtils.getTokenCredential(this.identity, RefreshToken.class);
        if (cred == null) {
            LOG.trace((Object)"RefreshToken is null");
            cred = new RefreshToken();
        }
        return cred;
    }

    @Produces
    @RequestScoped
    UserInfo currentUserInfo() {
        UserInfo userInfo = (UserInfo)((Object)OidcUtils.getAttribute(this.identity, "userinfo"));
        if (userInfo == null) {
            LOG.trace((Object)"UserInfo is null");
            userInfo = new UserInfo();
        }
        return userInfo;
    }

    @Produces
    @RequestScoped
    @IdToken
    TokenIntrospection idTokenIntrospection() {
        return this.tokenIntrospectionFromIdentityAttribute();
    }

    @Produces
    @RequestScoped
    TokenIntrospection tokenIntrospection() {
        TokenVerificationResult codeFlowAccessTokenResult = (TokenVerificationResult)OidcUtils.getAttribute(this.identity, "code_flow_access_token_result");
        if (codeFlowAccessTokenResult == null) {
            return this.tokenIntrospectionFromIdentityAttribute();
        }
        return OidcTokenCredentialProducer.tokenIntrospectionInstance(codeFlowAccessTokenResult.introspectionResult);
    }

    TokenIntrospection tokenIntrospectionFromIdentityAttribute() {
        TokenIntrospection introspection = (TokenIntrospection)((Object)OidcUtils.getAttribute(this.identity, "introspection"));
        return OidcTokenCredentialProducer.tokenIntrospectionInstance(introspection);
    }

    private static TokenIntrospection tokenIntrospectionInstance(TokenIntrospection introspection) {
        if (introspection == null) {
            LOG.trace((Object)"TokenIntrospection is null");
            introspection = new TokenIntrospection();
        }
        return introspection;
    }
}

