/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.config.metadata;

import java.lang.reflect.Method;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.internal.jpa.config.metadata.ReflectionHelper;

public class ReflectiveDynamicClassLoader
extends DynamicClassLoader {
    private Method defineClassMethod;

    public ReflectiveDynamicClassLoader(ClassLoader delegate) {
        super(delegate);
    }

    protected Method getDefineClassMethod() {
        if (this.defineClassMethod == null) {
            try {
                this.defineClassMethod = ReflectionHelper.getMethod(ClassLoader.class, "defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable t) {
                throw new RuntimeException("ReflectiveDynamicClassLoader could not access defineClass method", t);
            }
        }
        return this.defineClassMethod;
    }

    @Override
    protected Class<?> defineDynamicClass(String name, byte[] b) {
        try {
            return (Class)this.getDefineClassMethod().invoke((Object)this.getParent(), name, b, 0, b.length);
        }
        catch (Throwable t) {
            throw new RuntimeException("ReflectiveDynamicClassLoader failed to create class: " + name, t);
        }
    }
}

