/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import io.netty.resolver.AbstractAddressResolver;
import io.netty.resolver.AddressResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.regex.Pattern;

final class NonProxyHostAddressResolver
extends AbstractAddressResolver<InetSocketAddress> {
    private final Pattern nonProxyHostsPattern;
    private final AddressResolver<InetSocketAddress> defaultResolver;
    private final AddressResolver<InetSocketAddress> noopResolver;

    NonProxyHostAddressResolver(EventExecutor eventExecutor, Pattern nonProxyHostsPattern, AddressResolver<InetSocketAddress> defaultResolver, AddressResolver<InetSocketAddress> noopResolver) {
        super(eventExecutor);
        this.nonProxyHostsPattern = nonProxyHostsPattern;
        this.defaultResolver = defaultResolver;
        this.noopResolver = noopResolver;
    }

    protected boolean doIsResolved(InetSocketAddress address) {
        return !address.isUnresolved();
    }

    protected void doResolve(InetSocketAddress unresolvedAddress, Promise<InetSocketAddress> promise) {
        if (this.nonProxyHostsPattern.matcher(unresolvedAddress.getHostString()).matches()) {
            this.defaultResolver.resolve((SocketAddress)unresolvedAddress, promise);
        } else {
            this.noopResolver.resolve((SocketAddress)unresolvedAddress, promise);
        }
    }

    protected void doResolveAll(InetSocketAddress unresolvedAddress, Promise<List<InetSocketAddress>> promise) {
        if (this.nonProxyHostsPattern.matcher(unresolvedAddress.getHostString()).matches()) {
            this.defaultResolver.resolveAll((SocketAddress)unresolvedAddress, promise);
        } else {
            this.noopResolver.resolveAll((SocketAddress)unresolvedAddress, promise);
        }
    }
}

