/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.pipe.task;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStatus;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class SetPipeStatusPlanV2
extends ConfigPhysicalPlan {
    private String pipeName;
    private PipeStatus status;

    public SetPipeStatusPlanV2() {
        super(ConfigPhysicalPlanType.SetPipeStatusV2);
    }

    public SetPipeStatusPlanV2(String pipeName, PipeStatus status) {
        super(ConfigPhysicalPlanType.SetPipeStatusV2);
        this.pipeName = pipeName;
        this.status = status;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public PipeStatus getPipeStatus() {
        return this.status;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.pipeName, (OutputStream)stream);
        ReadWriteIOUtils.write((byte)this.status.getType(), (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.pipeName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.status = PipeStatus.getPipeStatus((byte)ReadWriteIOUtils.readByte((ByteBuffer)buffer));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SetPipeStatusPlanV2 that = (SetPipeStatusPlanV2)obj;
        return this.pipeName.equals(that.pipeName) && this.status.equals((Object)that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pipeName, this.status);
    }

    public String toString() {
        return "SetPipeStatusPlanV2{pipeName='" + this.pipeName + "', status='" + this.status + "'}";
    }
}

