/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.engine;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.DatasetGraphWrapperView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;

public class DatasetGraphWithGraphTransform
extends DatasetGraphWrapper
implements DatasetGraphWrapperView {
    private Function<Graph, ? extends Graph> graphTransform;

    public DatasetGraphWithGraphTransform(DatasetGraph dsg, Function<Graph, ? extends Graph> graphTransform) {
        super(dsg);
        this.graphTransform = graphTransform;
    }

    public DatasetGraphWithGraphTransform(DatasetGraph dsg, Context cxt, Function<Graph, ? extends Graph> graphTransform) {
        super(dsg, cxt);
        this.graphTransform = graphTransform;
    }

    private Graph wrapGraph(Graph graph) {
        Graph result = this.graphTransform.apply(graph);
        return result;
    }

    @Override
    public Graph getDefaultGraph() {
        Graph base = this.getG().getDefaultGraph();
        return this.wrapGraph(base);
    }

    @Override
    public Graph getUnionGraph() {
        Graph base = this.getG().getUnionGraph();
        return this.wrapGraph(base);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        Graph base = this.getG().getGraph(graphNode);
        if (base == null) {
            return null;
        }
        return this.wrapGraph(base);
    }

    @Override
    public Iterator<Quad> find() {
        return this.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    @Override
    public Iterator<Quad> find(Quad quad) {
        return this.find(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        Iterator<Quad> iter = this.findInf(g, s, p, o);
        if (iter == null) {
            return Iter.nullIterator();
        }
        return iter;
    }

    private Iterator<Quad> findInf(Node g, Node s, Node p, Node o) {
        if (g != null && g.isConcrete()) {
            return this.findOneGraphInf(g, s, p, o);
        }
        Iter<Quad> iter1 = this.findOneGraphInf(Quad.defaultGraphIRI, s, p, o);
        Iterator<Quad> iter2 = this.findAllNamedGraphInf(s, p, o);
        return iter1.append(iter2);
    }

    private Iterator<Quad> findAllNamedGraphInf(Node s, Node p, Node o) {
        return Iter.flatMap(this.listGraphNodes(), gn -> this.findOneGraphInf((Node)gn, s, p, o));
    }

    private Iter<Quad> findOneGraphInf(Node g, Node s, Node p, Node o) {
        if (!g.isConcrete()) {
            throw new IllegalStateException();
        }
        return Iter.iter((Iterator)this.getGraph(g).find(s, p, o)).map(t -> Quad.create(g, t));
    }

    @Override
    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        if (Quad.isDefaultGraph(g)) {
            throw new IllegalArgumentException("Default graph in findNG call");
        }
        if (g == null) {
            g = Node.ANY;
        }
        if (g == Node.ANY) {
            return this.findAllNamedGraphInf(s, p, o);
        }
        return this.findOneGraphInf(g, s, p, o);
    }

    @Override
    public boolean contains(Quad quad) {
        return this.contains(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Node g, Node s, Node p, Node o) {
        Iterator<Quad> iter = this.find(g, s, p, o);
        try {
            boolean bl = iter.hasNext();
            return bl;
        }
        finally {
            Iter.close(iter);
        }
    }
}

