/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.jena.atlas.lib.SetUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.table.Table1;
import org.apache.jena.sparql.algebra.table.TableBuilder;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.VarUtils;

public class QueryIterLateral
extends QueryIterRepeatApply {
    private final Op subOp;
    private final boolean isUnit;

    public QueryIterLateral(QueryIterator input, Op subOp, ExecutionContext execCxt) {
        super(input, execCxt);
        this.subOp = subOp;
        this.isUnit = QueryIterLateral.isJoinIdentity(subOp);
    }

    private static boolean isJoinIdentity(Op op) {
        if (!(op instanceof OpTable)) {
            return false;
        }
        OpTable table = (OpTable)op;
        return table.isJoinIdentity();
    }

    private static Op assignments(Op op, VarExprList varExprs) {
        return OpExtend.create(op, varExprs);
    }

    @Override
    protected QueryIterator nextStage(Binding binding) {
        if (this.isUnit) {
            return QueryIterSingleton.create(binding, super.getExecContext());
        }
        Op op = Substitute.inject(this.subOp, binding);
        return QC.execute(op, binding, super.getExecContext());
    }

    public static class TransformInject
    extends TransformCopy {
        private final Set<Var> injectVars;
        private final Set<Node> varsAsNodes;
        private final Function<Var, Node> replacement;
        private final Binding binding;
        private static final boolean substitute = true;
        private OpTable tableUnitTransformed = null;

        public TransformInject(Set<Var> injectVars, Binding binding) {
            this.injectVars = injectVars;
            this.varsAsNodes = Set.copyOf(injectVars);
            this.replacement = binding::get;
            this.binding = binding;
        }

        @Override
        public Op transform(OpBGP opBGP) {
            if (this.injectVars.isEmpty()) {
                return opBGP;
            }
            BasicPattern bp = opBGP.getPattern();
            List<Triple> triples = bp.getList();
            LinkedHashSet<Var> bgpVars = new LinkedHashSet<Var>();
            VarUtils.addVarsTriples(bgpVars, triples);
            Set<Var> x = SetUtils.intersection(bgpVars, this.injectVars);
            if (x.isEmpty()) {
                return opBGP;
            }
            VarExprList assigns = new VarExprList();
            BindingBuilder builder = BindingFactory.builder();
            for (Var var : x) {
                this.generateAssignmentVar(var, assigns, builder);
            }
            if (assigns.isEmpty()) {
                return super.transform(opBGP);
            }
            Binding substitutions = builder.build();
            Op opExec = Substitute.substitute(opBGP, substitutions);
            opExec = QueryIterLateral.assignments(opExec, assigns);
            return opExec;
        }

        @Override
        public Op transform(OpQuadPattern opQuadPattern) {
            BasicPattern bgp = opQuadPattern.getBasicPattern();
            VarExprList assigns = new VarExprList();
            BindingBuilder builder = BindingFactory.builder();
            Node gn = opQuadPattern.getGraphNode();
            this.generateAssignmentNode(gn, assigns, builder);
            for (Triple t : bgp) {
                this.generateAssignmentTriple(t, assigns, builder);
            }
            if (assigns.isEmpty()) {
                return super.transform(opQuadPattern);
            }
            Op opExec = opQuadPattern;
            Binding substitutions = builder.build();
            opExec = Substitute.substitute(opQuadPattern, substitutions);
            opExec = QueryIterLateral.assignments(opExec, assigns);
            return opExec;
        }

        @Override
        public Op transform(OpService opService, Op subOp) {
            Node g = opService.getService();
            if (!this.workToDo(g)) {
                return super.transform(opService, subOp);
            }
            VarExprList assigns = new VarExprList();
            BindingBuilder builder = BindingFactory.builder();
            Var var = Var.alloc(g);
            this.generateAssignmentVar(var, assigns, builder);
            if (assigns.isEmpty()) {
                return super.transform(opService, subOp);
            }
            Node g2 = g;
            Binding substitutions = builder.build();
            g2 = substitutions.get(var);
            OpService op2 = new OpService(g2, subOp, opService.getSilent());
            Op opExec = QueryIterLateral.assignments(op2, assigns);
            return opExec;
        }

        @Override
        public Op transform(OpGraph opGraph, Op subOp) {
            Node g = opGraph.getNode();
            if (!this.workToDo(g)) {
                return super.transform(opGraph, subOp);
            }
            VarExprList assigns = new VarExprList();
            BindingBuilder builder = BindingFactory.builder();
            Var var = Var.alloc(g);
            this.generateAssignmentVar(var, assigns, builder);
            if (assigns.isEmpty()) {
                return super.transform(opGraph, subOp);
            }
            Node g2 = g;
            Binding substitutions = builder.build();
            g2 = substitutions.get(var);
            OpGraph op2 = new OpGraph(g2, subOp);
            Op opExec = QueryIterLateral.assignments(op2, assigns);
            return opExec;
        }

        @Override
        public Op transform(OpDatasetNames opDatasetNames) {
            Node g = opDatasetNames.getGraphNode();
            if (!this.workToDo(g)) {
                return super.transform(opDatasetNames);
            }
            Var var = Var.alloc(g);
            Node g2 = this.replacement.apply(var);
            OpGraph op2 = new OpGraph(g2, OpTable.unit());
            return op2;
        }

        @Override
        public Op transform(OpPath opPath) {
            TriplePath path = opPath.getTriplePath();
            VarExprList assigns = new VarExprList();
            BindingBuilder builder = BindingFactory.builder();
            if (path.isTriple()) {
                Triple t1 = path.asTriple();
                this.generateAssignmentTriple(t1, assigns, builder);
                Triple t2 = this.applyReplacement(t1, this.replacement);
                if (t1.equals(t2)) {
                    return opPath;
                }
                TriplePath path2 = new TriplePath(t2);
                return new OpPath(path2);
            }
            Node s = path.getSubject();
            Node o = path.getObject();
            if (!this.workToDo(s) && !this.workToDo(o)) {
                return super.transform(opPath);
            }
            this.generateAssignmentNode(s, assigns, builder);
            this.generateAssignmentNode(o, assigns, builder);
            if (assigns.isEmpty()) {
                return super.transform(opPath);
            }
            Node s2 = TransformInject.applyReplacement(s, this.replacement);
            Node o2 = TransformInject.applyReplacement(o, this.replacement);
            TriplePath path2 = new TriplePath(s2, path.getPath(), o2);
            OpPath op2 = new OpPath(path2);
            Op opExec = QueryIterLateral.assignments(op2, assigns);
            return opExec;
        }

        @Override
        public Op transform(OpTriple opTriple) {
            Triple triple = opTriple.getTriple();
            VarExprList assigns = new VarExprList();
            BindingBuilder builder = BindingFactory.builder();
            this.generateAssignmentTriple(triple, assigns, builder);
            if (assigns.isEmpty()) {
                return super.transform(opTriple);
            }
            Triple t2 = triple;
            t2 = this.applyReplacement(triple, this.replacement);
            OpTriple op2 = new OpTriple(t2);
            Op opExec = QueryIterLateral.assignments(op2, assigns);
            return opExec;
        }

        @Override
        public Op transform(OpTable opTable) {
            if (opTable.isJoinIdentity()) {
                if (this.tableUnitTransformed == null) {
                    Table1 table2 = new Table1(this.binding);
                    this.tableUnitTransformed = OpTable.create(table2);
                }
                return this.tableUnitTransformed;
            }
            Table table = opTable.getTable();
            TableBuilder tableBuilder = TableFactory.builder();
            tableBuilder.addVars(table.getVars());
            tableBuilder.addVarsFromRow(this.binding);
            BindingBuilder builder = BindingFactory.builder();
            table.iterator(null).forEachRemaining(row -> {
                builder.reset();
                builder.addAll((Binding)row);
                this.binding.forEach(builder::set);
                tableBuilder.addRow(builder.build());
            });
            Table newTable = tableBuilder.build();
            return OpTable.create(newTable);
        }

        private Triple applyReplacement(Triple triple, Function<Var, Node> replacement) {
            Node s2 = TransformInject.applyReplacement(triple.getSubject(), replacement);
            Node p2 = TransformInject.applyReplacement(triple.getPredicate(), replacement);
            Node o2 = TransformInject.applyReplacement(triple.getObject(), replacement);
            Triple t2 = Triple.create(s2, p2, o2);
            return t2;
        }

        private void generateAssignmentTriple(Triple triple, VarExprList assigns, BindingBuilder builder) {
            Node s = triple.getSubject();
            Node p = triple.getPredicate();
            Node o = triple.getObject();
            if (!(this.workToDo(s) || this.workToDo(p) || this.workToDo(o))) {
                return;
            }
            this.generateAssignmentNode(s, assigns, builder);
            this.generateAssignmentNode(p, assigns, builder);
            this.generateAssignmentNode(o, assigns, builder);
        }

        private static Node applyReplacement(Node n, Function<Var, Node> replacement) {
            if (n instanceof Var) {
                Var x = (Var)n;
                Node x2 = replacement.apply(x);
                return x2 == null ? n : x2;
            }
            return n;
        }

        private void generateAssignmentNode(Node n, VarExprList assigns, BindingBuilder builder) {
            if (n == null) {
                return;
            }
            if (!Var.isVar(n)) {
                return;
            }
            this.generateAssignmentVar(Var.alloc(n), assigns, builder);
        }

        private void generateAssignmentVar(Var var, VarExprList assigns, BindingBuilder builder) {
            Node value = this.replacement.apply(var);
            if (value != null && !builder.contains(var)) {
                builder.add(var, value);
                assigns.add(var, NodeValue.makeNode(value));
            }
        }

        private boolean workToDo(Node n) {
            if (n == null) {
                return false;
            }
            if (!Var.isVar(n)) {
                return false;
            }
            Var v = Var.alloc(n);
            return null != this.replacement.apply(v);
        }
    }
}

