/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.expr.NVDatatypes;
import org.apache.jena.sparql.expr.NVOps;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueBoolean;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDateTime;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDecimal;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDouble;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDuration;
import org.apache.jena.sparql.expr.nodevalue.NodeValueFloat;
import org.apache.jena.sparql.expr.nodevalue.NodeValueInteger;
import org.apache.jena.sparql.expr.nodevalue.NodeValueLang;
import org.apache.jena.sparql.expr.nodevalue.NodeValueLangDir;
import org.apache.jena.sparql.expr.nodevalue.NodeValueNode;
import org.apache.jena.sparql.expr.nodevalue.NodeValueString;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.sparql.util.RomanNumeral;
import org.apache.jena.sparql.util.RomanNumeralDatatype;
import org.apache.jena.vocabulary.RDF;

class NVFactory {
    private static Map<RDFDatatype, ToNodeValue> mapper = NVFactory.dtSetup();

    NVFactory() {
    }

    static NodeValue create(Node node) {
        if (!node.isLiteral()) {
            return new NodeValueNode(node);
        }
        RDFDatatype datatype = node.getLiteralDatatype();
        boolean hasLangTag = NodeUtils.hasLang(node);
        if (hasLangTag) {
            if (NodeUtils.hasLangDir(node)) {
                if (!RDF.dtDirLangString.equals(datatype)) {
                    throw new InternalErrorException("Wrong type for literal with a text direction");
                }
                return new NodeValueLangDir(node);
            }
            if (!RDF.dtLangString.equals(datatype)) {
                throw new InternalErrorException("Wrong type for literal with a langugae tag");
            }
            return new NodeValueLang(node);
        }
        ToNodeValue function = mapper.get(datatype);
        if (function == null) {
            return new NodeValueNode(node);
        }
        NodeValue nv = function.create(datatype, node);
        if (nv == null) {
            return new NodeValueNode(node);
        }
        return nv;
    }

    public static NodeValue create(RDFDatatype datatype, Node node) {
        return mapper.get(datatype).create(datatype, node);
    }

    private static Map<RDFDatatype, ToNodeValue> dtSetup() {
        HashMap<RDFDatatype, ToNodeValue> mapper = new HashMap<RDFDatatype, ToNodeValue>();
        NVFactory.entry(mapper, NVDatatypes.XSDdecimal, NVFactory::decimalMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDfloat, NVFactory::floatMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDdouble, NVFactory::doubleMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDinteger, NVFactory::integerMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDnonPositiveInteger, NVFactory::integerMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDnonNegativeInteger, NVFactory::integerMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDpositiveInteger, NVFactory::integerMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDnegativeInteger, NVFactory::integerMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDbyte, NVFactory::integerMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDshort, NVFactory::integerMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDint, NVFactory::integerMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDlong, NVFactory::integerMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDunsignedByte, NVFactory::integerMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDunsignedShort, NVFactory::integerMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDunsignedInt, NVFactory::integerMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDunsignedLong, NVFactory::integerMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDboolean, NVFactory::booleanMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDstring, NVFactory::stringMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDnormalizedString, NVFactory::stringMaker);
        NVFactory.entry(mapper, RDF.dtLangString, NVFactory::langStringMaker);
        NVFactory.entry(mapper, RDF.dtDirLangString, NVFactory::dirLangStringMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDdate, NVFactory::dateTimeMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDtime, NVFactory::dateTimeMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDdateTime, NVFactory::dateTimeMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDdateTimeStamp, NVFactory::dateTimeMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDgDay, NVFactory::dateTimeMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDgMonth, NVFactory::dateTimeMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDgYear, NVFactory::dateTimeMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDgYearMonth, NVFactory::dateTimeMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDgMonthDay, NVFactory::dateTimeMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDduration, NVFactory::durationMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDdayTimeDuration, NVFactory::durationMaker);
        NVFactory.entry(mapper, NVDatatypes.XSDyearMonthDuration, NVFactory::durationMaker);
        if (SystemARQ.EnableRomanNumerals) {
            NVFactory.entry(mapper, RomanNumeralDatatype.get(), NVFactory::romanNumeralMaker);
        }
        return Map.copyOf(mapper);
    }

    private static void entry(Map<RDFDatatype, ToNodeValue> map, RDFDatatype rdfDatatype, ToNodeValue toNodeValue) {
        map.put(rdfDatatype, toNodeValue);
    }

    private static NodeValue integerMaker(RDFDatatype datatype, Node node) {
        if (!node.getLiteral().isWellFormed()) {
            return null;
        }
        String trimmedLexical = node.getLiteralLexicalForm().trim();
        if (!datatype.isValid(trimmedLexical)) {
            return null;
        }
        BigInteger bigInteger = new BigInteger(trimmedLexical);
        return new NodeValueInteger(bigInteger, node);
    }

    private static NodeValue floatMaker(RDFDatatype datatype, Node node) {
        if (!node.getLiteral().isWellFormed()) {
            return null;
        }
        LiteralLabel lit = node.getLiteral();
        float f = ((Number)lit.getValue()).floatValue();
        return new NodeValueFloat(f, node);
    }

    private static NodeValue doubleMaker(RDFDatatype datatype, Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!lit.isWellFormed()) {
            return null;
        }
        double d = ((Number)lit.getValue()).doubleValue();
        return new NodeValueDouble(d, node);
    }

    private static NodeValue decimalMaker(RDFDatatype datatype, Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!lit.isWellFormed()) {
            return null;
        }
        String trimmedLexical = node.getLiteralLexicalForm().trim();
        BigDecimal decimal = new BigDecimal(trimmedLexical);
        return new NodeValueDecimal(decimal, node);
    }

    private static NodeValue booleanMaker(RDFDatatype datatype, Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!lit.isWellFormed()) {
            return null;
        }
        boolean b = (Boolean)lit.getValue();
        return new NodeValueBoolean(b, node);
    }

    private static NodeValue stringMaker(RDFDatatype datatype, Node node) {
        return new NodeValueString(node.getLiteralLexicalForm(), node);
    }

    private static NodeValue langStringMaker(RDFDatatype datatype, Node node) {
        return new NodeValueLang(node);
    }

    private static NodeValue dirLangStringMaker(RDFDatatype datatype, Node node) {
        return new NodeValueLangDir(node);
    }

    private static NodeValue dateTimeMaker(RDFDatatype datatype, Node node) {
        String trimmedLexical = node.getLiteralLexicalForm().trim();
        try {
            XMLGregorianCalendar gCal = NVFactory.createXMLGregorianCalendar(trimmedLexical, node);
            boolean isCorrect = NVOps.checkCalendarInstance(gCal, datatype);
            if (!isCorrect) {
                return null;
            }
            return new NodeValueDateTime(gCal, node);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private static XMLGregorianCalendar createXMLGregorianCalendar(String lex, Node n) {
        if (NVDatatypes.XSDgMonth.equals(n.getLiteralDatatype()) && lex.endsWith("Z")) {
            String lex2 = lex.substring(0, lex.length() - 1);
            XMLGregorianCalendar gCal = NodeValue.xmlDatatypeFactory.newXMLGregorianCalendar(lex2);
            gCal.setTimezone(0);
            return gCal;
        }
        XMLGregorianCalendar gCal = NodeValue.xmlDatatypeFactory.newXMLGregorianCalendar(lex);
        return gCal;
    }

    private static NodeValue durationMaker(RDFDatatype datatype, Node node) {
        String trimmedLexical = node.getLiteralLexicalForm().trim();
        try {
            Duration duration = NodeValue.xmlDatatypeFactory.newDuration(trimmedLexical);
            boolean isCorrect = NVOps.checkDurationInstance(duration, datatype);
            if (!isCorrect) {
                return null;
            }
            return new NodeValueDuration(duration, node);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private static NodeValue romanNumeralMaker(RDFDatatype datatype, Node node) {
        LiteralLabel lit = node.getLiteral();
        Object obj = RomanNumeralDatatype.get().parse(lit.getLexicalForm());
        if (obj instanceof Integer) {
            return new NodeValueInteger(((Integer)obj).longValue());
        }
        if (obj instanceof RomanNumeral) {
            return new NodeValueInteger(((RomanNumeral)obj).intValue());
        }
        throw new ARQInternalErrorException("DatatypeFormatException: Roman numeral is unknown class");
    }

    private static NodeValue hexBinaryToNodeValue(RDFDatatype datatype, Node node) {
        return new NodeValueNode(node);
    }

    @FunctionalInterface
    static interface ToNodeValue {
        public NodeValue create(RDFDatatype var1, Node var2);
    }
}

