/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.index.bplustree;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.tdb1.base.buffer.PtrBuffer;
import org.apache.jena.tdb1.base.buffer.RecordBuffer;
import org.apache.jena.tdb1.base.record.Record;
import org.apache.jena.tdb1.base.record.RecordFactory;
import org.apache.jena.tdb1.index.bplustree.BPTreeNode;
import org.apache.jena.tdb1.index.bplustree.BPTreeNodeMgr;

class BPTreeNodeBuilder
implements Iterator<Pair<Integer, Record>> {
    private Pair<Integer, Record> slot;
    private Iterator<Pair<Integer, Record>> iter;
    private final BPTreeNodeMgr mgr;
    private final boolean leafLayer;
    private final RecordFactory recordFactory;

    BPTreeNodeBuilder(Iterator<Pair<Integer, Record>> iter, BPTreeNodeMgr mgr, boolean leafLayer, RecordFactory recordFactory) {
        this.iter = iter;
        this.mgr = mgr;
        this.leafLayer = leafLayer;
        this.recordFactory = recordFactory;
    }

    @Override
    public boolean hasNext() {
        if (this.slot != null) {
            return true;
        }
        if (this.iter == null) {
            return false;
        }
        if (!this.iter.hasNext()) {
            this.iter = null;
            return false;
        }
        BPTreeNode bptNode = this.mgr.createNode(-1);
        bptNode.setIsLeaf(this.leafLayer);
        RecordBuffer recBuff = bptNode.getRecordBuffer();
        PtrBuffer ptrBuff = bptNode.getPtrBuffer();
        recBuff.setSize(0);
        ptrBuff.setSize(0);
        int rMax = recBuff.maxSize();
        int pMax = ptrBuff.maxSize();
        while (this.iter.hasNext()) {
            int X2 = bptNode.getCount();
            int X22 = bptNode.getMaxSize();
            int P = ptrBuff.size();
            int P2 = ptrBuff.maxSize();
            int R = recBuff.size();
            int R2 = recBuff.maxSize();
            Pair<Integer, Record> pair = this.iter.next();
            Record r = pair.cdr();
            r = this.recordFactory.create(r.getKey());
            if (ptrBuff.isFull()) {
                Log.error(this, "PtrBuffer is full");
            }
            ptrBuff.add(pair.car());
            if (ptrBuff.isFull()) {
                if (!ptrBuff.isFull()) {
                    Log.error(this, "PtrBuffer is not full");
                }
                this.slot = new Pair<Integer, Record>(bptNode.getId(), pair.cdr());
                this.mgr.put(bptNode);
                return true;
            }
            recBuff.add(r);
            bptNode.setCount(bptNode.getCount() + 1);
        }
        Record r = recBuff.getHigh();
        recBuff.removeTop();
        bptNode.setCount(bptNode.getCount() - 1);
        this.slot = new Pair<Integer, Record>(bptNode.getId(), r);
        this.mgr.put(bptNode);
        return true;
    }

    @Override
    public Pair<Integer, Record> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Pair<Integer, Record> x = this.slot;
        this.slot = null;
        return x;
    }
}

