/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Map;
import javax.measure.IncommensurableException;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.CartesianToPolar;
import org.apache.sis.referencing.operation.transform.CartesianToSpherical;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.PolarToCartesian;
import org.apache.sis.referencing.operation.transform.SphericalToCartesian;
import org.apache.sis.referencing.util.CoordinateOperations;
import org.apache.sis.referencing.util.WKTUtilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.util.FactoryException;

abstract class CoordinateSystemTransform
extends AbstractMathTransform {
    private final int dimension;
    private final transient OperationMethod method;
    private final transient OperationMethod method3D;
    final transient ContextualParameters context;
    private volatile transient MathTransform complete;
    private volatile transient MathTransform passthrough;

    CoordinateSystemTransform(String method, String method3D, int dimension) {
        this.dimension = dimension;
        this.method = CoordinateSystemTransform.method(method);
        this.method3D = method3D != null ? CoordinateSystemTransform.method(method3D) : this.method;
        this.context = new ContextualParameters(this.method.getParameters(), dimension, dimension);
    }

    private static OperationMethod method(String name) {
        Map<String, ImmutableIdentifier> properties = Map.of("name", new ImmutableIdentifier(Citations.SIS, "SIS", name));
        DefaultParameterDescriptorGroup descriptor = new DefaultParameterDescriptorGroup(properties, 1, 1, new GeneralParameterDescriptor[0]);
        return new DefaultOperationMethod(properties, descriptor);
    }

    final MathTransform completeTransform(MathTransformFactory factory) throws FactoryException {
        MathTransform tr = this.complete;
        if (tr == null) {
            tr = this.context.completeTransform(factory, this);
            if (CoordinateOperations.isDefaultInstance(factory)) {
                this.complete = tr;
            }
        }
        return tr;
    }

    final MathTransform passthrough(MathTransformFactory factory) throws FactoryException {
        MathTransform tr = this.passthrough;
        if (tr == null) {
            tr = factory.createPassThroughTransform(0, this.completeTransform(factory), 1);
            if (CoordinateOperations.isDefaultInstance(factory)) {
                this.passthrough = tr;
            }
        }
        return tr;
    }

    @Override
    public final int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public final int getTargetDimensions() {
        return this.dimension;
    }

    @Override
    public final ParameterValueGroup getParameterValues() {
        return this.context;
    }

    @Override
    protected final ContextualParameters getContextualParameters() {
        return this.context;
    }

    static MathTransform create(MathTransformFactory factory, CoordinateSystem source, CoordinateSystem target, ThreadLocal<OperationMethod> lastMethod) throws FactoryException {
        int passthrough = 0;
        CoordinateSystemTransform kernel = null;
        if (source instanceof CartesianCS) {
            if (target instanceof SphericalCS) {
                kernel = CartesianToSpherical.INSTANCE;
            } else if (target instanceof PolarCS) {
                kernel = CartesianToPolar.INSTANCE;
            } else if (target instanceof CylindricalCS) {
                kernel = CartesianToPolar.INSTANCE;
                passthrough = 1;
            }
        } else if (target instanceof CartesianCS) {
            if (source instanceof SphericalCS) {
                kernel = SphericalToCartesian.INSTANCE;
            } else if (source instanceof PolarCS) {
                kernel = PolarToCartesian.INSTANCE;
            } else if (source instanceof CylindricalCS) {
                kernel = PolarToCartesian.INSTANCE;
                passthrough = 1;
            }
        }
        Exception cause = null;
        try {
            if (kernel == null) {
                return factory.createAffineTransform(CoordinateSystems.swapAndScaleAxes(source, target));
            }
            if (source.getDimension() == kernel.getSourceDimensions() + passthrough && target.getDimension() == kernel.getTargetDimensions() + passthrough) {
                MathTransform tr = passthrough == 0 ? kernel.completeTransform(factory) : kernel.passthrough(factory);
                MathTransform before = factory.createAffineTransform(CoordinateSystems.swapAndScaleAxes(source, CoordinateSystems.replaceAxes(source, AxesConvention.NORMALIZED)));
                MathTransform after = factory.createAffineTransform(CoordinateSystems.swapAndScaleAxes(CoordinateSystems.replaceAxes(target, AxesConvention.NORMALIZED), target));
                MathTransform result = factory.createConcatenatedTransform(before, factory.createConcatenatedTransform(tr, after));
                lastMethod.set(passthrough == 0 ? kernel.method : kernel.method3D);
                return result;
            }
        }
        catch (IllegalArgumentException | IncommensurableException e2) {
            cause = e2;
        }
        throw new OperationNotFoundException(Resources.format((short)13, WKTUtilities.toType(CoordinateSystem.class, source.getClass()), WKTUtilities.toType(CoordinateSystem.class, target.getClass())), cause);
    }
}

