/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.net.URI;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.util.Classes;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.Context;
import org.opengis.util.InternationalString;

@XmlTransient
public class XLink
implements Serializable {
    private static final long serialVersionUID = 4046720871882443681L;
    private Type type;
    private URI href;
    private URI role;
    private URI arcrole;
    private InternationalString title;
    private Show show;
    private Actuate actuate;
    private String label;
    private String from;
    private String to;
    private int hashCode;

    public XLink() {
    }

    public XLink(XLink link) {
        if (link != null) {
            this.type = link.type;
            this.href = link.href;
            this.role = link.role;
            this.arcrole = link.arcrole;
            this.title = link.title;
            this.show = link.show;
            this.actuate = link.actuate;
            this.label = link.label;
            this.from = link.from;
            this.to = link.to;
        }
    }

    private int fieldMask() {
        int mask = 0;
        if (this.type != null) {
            mask |= 1;
        }
        if (this.href != null) {
            mask |= 2;
        }
        if (this.role != null) {
            mask |= 4;
        }
        if (this.arcrole != null) {
            mask |= 8;
        }
        if (this.title != null) {
            mask |= 0x10;
        }
        if (this.show != null) {
            mask |= 0x20;
        }
        if (this.actuate != null) {
            mask |= 0x40;
        }
        if (this.label != null) {
            mask |= 0x80;
        }
        if (this.from != null) {
            mask |= 0x100;
        }
        if (this.to != null) {
            mask |= 0x200;
        }
        return mask;
    }

    @XmlAttribute(name="type", namespace="http://www.w3.org/1999/xlink", required=true)
    public Type getType() {
        if (this.type != Type.AUTO) {
            return this.type;
        }
        Type best = null;
        int min2 = 32;
        int defined = this.fieldMask();
        int undefined = ~(defined | 1);
        for (Type candidate : Type.values()) {
            int n;
            int forbidden = ~candidate.fieldMask;
            if (forbidden == 0 || (defined & forbidden) != 0 || (undefined & candidate.mandatory) != 0 || (n = Integer.bitCount(undefined & candidate.fieldMask)) >= min2) continue;
            min2 = n;
            best = candidate;
        }
        return best;
    }

    public void setType(Type type) {
        this.canWrite(1, "type", "type");
        if (type != null && (this.fieldMask() & ~type.fieldMask) != 0) {
            throw new IllegalStateException(Errors.format((short)67, "type", type.identifier()));
        }
        this.type = type;
    }

    private void canWrite(int field, String name, Object value) throws IllegalStateException {
        if (this.hashCode != 0) {
            throw new UnsupportedOperationException(Errors.format((short)153, "XLink"));
        }
        Type type = this.type;
        if (type != null) {
            if (value != null) {
                if ((type.fieldMask & field) == 0) {
                    throw new IllegalStateException(Errors.format((short)40, name, type.identifier()));
                }
            } else if ((type.mandatory & field) != 0) {
                throw new IllegalStateException(Errors.format((short)76, name, type.identifier()));
            }
        }
    }

    @XmlSchemaType(name="anyURI")
    @XmlAttribute(name="href", namespace="http://www.w3.org/1999/xlink")
    public URI getHRef() {
        return this.href;
    }

    public void setHRef(URI href) throws IllegalStateException {
        this.canWrite(2, "href", href);
        this.href = href;
    }

    @XmlSchemaType(name="anyURI")
    @XmlAttribute(name="role", namespace="http://www.w3.org/1999/xlink")
    public URI getRole() {
        return this.role;
    }

    public void setRole(URI role) throws IllegalStateException {
        this.canWrite(4, "role", role);
        this.role = role;
    }

    @XmlSchemaType(name="anyURI")
    @XmlAttribute(name="arcrole", namespace="http://www.w3.org/1999/xlink")
    public URI getArcRole() {
        return this.arcrole;
    }

    public void setArcRole(URI arcrole) throws IllegalStateException {
        this.canWrite(8, "arcrole", arcrole);
        this.arcrole = arcrole;
    }

    @XmlAttribute(name="title", namespace="http://www.w3.org/1999/xlink")
    public InternationalString getTitle() {
        return this.title;
    }

    public void setTitle(InternationalString title) throws IllegalStateException {
        this.canWrite(16, "title", title);
        this.title = title;
    }

    @XmlAttribute(name="show", namespace="http://www.w3.org/1999/xlink")
    public Show getShow() {
        return this.show;
    }

    public void setShow(Show show) throws IllegalStateException {
        this.canWrite(32, "show", (Object)show);
        this.show = show;
    }

    @XmlAttribute(name="actuate", namespace="http://www.w3.org/1999/xlink")
    public Actuate getActuate() {
        return this.actuate;
    }

    public void setActuate(Actuate actuate) throws IllegalStateException {
        this.canWrite(64, "actuate", (Object)actuate);
        this.actuate = actuate;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) throws IllegalStateException {
        this.canWrite(128, "label", label);
        this.label = label;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) throws IllegalStateException {
        this.canWrite(256, "from", from);
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) throws IllegalStateException {
        this.canWrite(512, "to", to);
        this.to = to;
    }

    public void freeze() {
        if (this.hashCode == 0) {
            this.hashCode = this.hash();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            int h1;
            XLink that = (XLink)object;
            int h0 = this.hashCode;
            if (h0 != 0 && (h1 = that.hashCode) != 0 && h0 != h1) {
                return false;
            }
            return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.href, that.href) && Objects.equals(this.role, that.role) && Objects.equals(this.arcrole, that.arcrole) && Objects.equals(this.title, that.title) && Objects.equals((Object)this.show, (Object)that.show) && Objects.equals((Object)this.actuate, (Object)that.actuate) && Objects.equals(this.label, that.label) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.hashCode;
        if (hash == 0) {
            hash = this.hash();
        }
        return hash;
    }

    private int hash() {
        int hash = Objects.hash(new Object[]{this.href, this.role, this.arcrole, this.title, this.show, this.actuate, this.label, this.from, this.to, this.type}) ^ 0x49B64BA1;
        if (hash == 0) {
            hash = -1;
        }
        return hash;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(64);
        buffer.append(Classes.getShortClassName(this)).append('[');
        XLink.append(buffer, "type", (Object)this.getType());
        XLink.append(buffer, "href", this.getHRef());
        XLink.append(buffer, "role", this.getRole());
        XLink.append(buffer, "arcrole", this.getArcRole());
        XLink.append(buffer, "title", this.getTitle());
        XLink.append(buffer, "show", (Object)this.getShow());
        XLink.append(buffer, "actuate", (Object)this.getActuate());
        XLink.append(buffer, "label", this.getLabel());
        XLink.append(buffer, "from", this.getFrom());
        XLink.append(buffer, "to", this.getTo());
        return buffer.append(']').toString();
    }

    private static void append(StringBuilder buffer, String label, Object value) {
        if (value != null) {
            if (buffer.charAt(buffer.length() - 1) != '[') {
                buffer.append(", ");
            }
            if (value instanceof Enum) {
                try {
                    XmlEnumValue xml = value.getClass().getField(((Enum)value).name()).getAnnotation(XmlEnumValue.class);
                    if (xml != null) {
                        value = xml.value();
                    }
                }
                catch (NoSuchFieldException e2) {
                    Logging.unexpectedException(Context.LOGGER, XLink.class, "toString", e2);
                }
            }
            buffer.append(label).append("=\"").append(value).append('\"');
        }
    }

    @XmlEnum
    public static enum Type {
        SIMPLE(127, 1),
        EXTENDED(21, 1),
        LOCATOR(151, 3),
        RESOURCE(149, 1),
        ARC(889, 1),
        TITLE(1, 1),
        AUTO(-1, 0);

        final int fieldMask;
        final int mandatory;

        private Type(int mask, int mandatory) {
            this.fieldMask = mask;
            this.mandatory = mandatory;
        }

        final String identifier() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    @XmlEnum
    public static enum Show {
        NEW,
        REPLACE,
        EMBED,
        OTHER,
        NONE;

    }

    @XmlEnum
    public static enum Actuate {
        ON_LOAD,
        ON_REQUEST,
        OTHER,
        NONE;

    }
}

