/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.RolloverFileOutputStream;
import org.eclipse.jetty.util.TypeUtil;

public class DebugHandler
extends Handler.Wrapper
implements Connection.Listener {
    private static final DateCache __date = new DateCache("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    private OutputStream _out;
    private PrintStream _print;
    private boolean _showHeaders;
    private final String _attr = String.format("__R%s@%x", TypeUtil.toShortName(this.getClass()), System.identityHashCode(this));

    public DebugHandler() {
        this((Handler)null);
    }

    public DebugHandler(Handler handler) {
        super(handler);
    }

    public boolean isShowHeaders() {
        return this._showHeaders;
    }

    public void setShowHeaders(boolean showHeaders) {
        this._showHeaders = showHeaders;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        boolean bl;
        block7: {
            HandlingCallback handlingCallback;
            Throwable ex;
            block6: {
                Thread thread = Thread.currentThread();
                String origName = thread.getName();
                String threadName = origName + ":" + request.getHttpURI().getPathQuery();
                boolean willHandle = false;
                ex = null;
                String rname = this.findRequestName(request);
                handlingCallback = new HandlingCallback(callback, request, response);
                try {
                    thread.setName(threadName);
                    String headers = this._showHeaders ? "\n" + request.getHeaders().toString() : "";
                    this.log(">> r=%s %s %s %s %s %s", rname, request.getMethod(), request.getHttpURI(), request.getConnectionMetaData().getProtocol(), request.getConnectionMetaData(), headers);
                    bl = willHandle = this.getHandler().handle(request, response, handlingCallback);
                    thread.setName(origName);
                    if (willHandle) break block6;
                }
                catch (Throwable x) {
                    try {
                        ex = x;
                        throw x;
                    }
                    catch (Throwable throwable) {
                        thread.setName(origName);
                        if (!willHandle) {
                            this.log("!! r=%s not handled", rname);
                        } else {
                            handlingCallback.onHandlingCompleted(ex);
                        }
                        throw throwable;
                    }
                }
                this.log("!! r=%s not handled", rname);
                break block7;
            }
            handlingCallback.onHandlingCompleted(ex);
        }
        return bl;
    }

    protected void log(String format, Object ... arg) {
        if (!this.isRunning()) {
            return;
        }
        String s = String.format(format, arg);
        String threadName = Thread.currentThread().getName();
        long now2 = System.currentTimeMillis();
        long ms = now2 % 1000L;
        if (this._print != null) {
            this._print.printf("%s.%03d:%s:%s%n", __date.format(now2), ms, threadName, s);
        }
    }

    protected String findRequestName(Request request) {
        if (request == null) {
            return null;
        }
        try {
            String n = (String)request.getAttribute(this._attr);
            if (n == null) {
                n = String.format("%s@%x", request.getHttpURI(), request.hashCode());
                request.setAttribute(this._attr, n);
            }
            return n;
        }
        catch (IllegalStateException e2) {
            return String.format("%s@%x", request.getHttpURI(), request.hashCode());
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this._out == null) {
            this._out = new RolloverFileOutputStream("./logs/yyyy_mm_dd.debug.log", true);
        }
        this._print = new PrintStream(this._out);
        for (Connector connector : this.getServer().getConnectors()) {
            if (!(connector instanceof AbstractConnector)) continue;
            connector.addBean(this, false);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._print.close();
        for (Connector connector : this.getServer().getConnectors()) {
            if (!(connector instanceof AbstractConnector)) continue;
            connector.removeBean(this);
        }
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void setOutputStream(OutputStream out) {
        this._out = out;
    }

    @Override
    public void onOpened(Connection connection) {
        this.log("%s OPENED %s", Thread.currentThread().getName(), connection.toString());
    }

    @Override
    public void onClosed(Connection connection) {
        this.log("%s CLOSED %s", Thread.currentThread().getName(), connection.toString());
    }

    private class HandlingCallback
    extends Callback.Nested {
        private final Request _request;
        private final Response _response;
        private final AtomicBoolean _completing;

        private HandlingCallback(Callback callback, Request request, Response response) {
            super(callback);
            this._completing = new AtomicBoolean(false);
            this._request = request;
            this._response = response;
        }

        private void onHandlingCompleted(Throwable throwable) {
            if (this._completing.compareAndSet(false, true)) {
                this.logContinuation();
            } else {
                this.logCompletion(throwable);
            }
        }

        private void onCallbackCompleted(Throwable throwable) {
            if (!this._completing.compareAndSet(false, true)) {
                this.logCompletion(throwable);
            }
        }

        private void logCompletion(Throwable throwable) {
            DebugHandler.this.log("<< r=%s async=false %d %s%n%s", DebugHandler.this.findRequestName(this._request), this._response.getStatus(), throwable == null ? "" : throwable.toString(), this._response.getHeaders());
        }

        private void logContinuation() {
            DebugHandler.this.log("|| r=%s async=true", DebugHandler.this.findRequestName(this._request));
        }

        @Override
        public void succeeded() {
            this.onCallbackCompleted(null);
            super.succeeded();
        }

        @Override
        public void failed(Throwable x) {
            this.onCallbackCompleted(x);
            super.failed(x);
        }
    }
}

