/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.command;

import aQute.lib.io.IO;
import aQute.libg.qtokens.QuotedTokenizer;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Command {
    private static final Logger logger = LoggerFactory.getLogger(Command.class);
    private static final int TIMEDOUT = 123;
    boolean trace;
    Reporter reporter;
    List<String> arguments = new ArrayList<String>();
    Map<String, String> variables = new LinkedHashMap<String, String>();
    long timeout = 0L;
    File cwd = new File("").getAbsoluteFile();
    volatile Process process;
    volatile boolean timedout;
    private boolean useThreadForInput;
    private static final Pattern escapedDoubleQuote = Pattern.compile("([\\\\]*)\"");
    private static final Pattern trailingBackslash = Pattern.compile("([\\\\]*)\\z");

    public Command(String fullCommand) {
        this();
        this.full(fullCommand);
    }

    public Command() {
    }

    public int execute(Appendable stdout, Appendable stderr) throws Exception {
        return this.execute((InputStream)null, stdout, stderr);
    }

    public int execute(String input, Appendable stdout, Appendable stderr) throws Exception {
        InputStream in = input == null ? null : IO.stream(input, StandardCharsets.UTF_8);
        return this.execute(in, stdout, stderr);
    }

    public static boolean needsWindowsQuoting(String s) {
        int len = s.length();
        if (len == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            switch (s.charAt(i)) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '\\': {
                    return true;
                }
            }
        }
        return false;
    }

    public static String windowsQuote(String s) {
        if (!Command.needsWindowsQuoting(s)) {
            return s;
        }
        s = escapedDoubleQuote.matcher(s).replaceAll("$1$1\\\\\"");
        s = trailingBackslash.matcher(s).replaceAll("$1$1");
        return "\"" + s + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(InputStream in, Appendable stdout, Appendable stderr) throws Exception {
        boolean systemIn = in == System.in;
        logger.debug("executing cmd: {}", this.getArguments());
        ProcessBuilder p = new ProcessBuilder(this.getArguments());
        if (IO.isWindows()) {
            p.command(p.command().stream().map(Command::windowsQuote).collect(Collectors.toList()));
        }
        p.environment().putAll(this.variables);
        p.directory(this.cwd);
        if (systemIn) {
            p.redirectInput(ProcessBuilder.Redirect.INHERIT);
        }
        Process process = this.process = p.start();
        Thread hook = new Thread(process::destroy, this.getArguments().toString());
        Runtime.getRuntime().addShutdownHook(hook);
        ScheduledExecutorService scheduler = null;
        if (this.timeout != 0L) {
            scheduler = Executors.newScheduledThreadPool(1);
            scheduler.schedule(() -> {
                this.timedout = true;
                process.destroy();
            }, this.timeout, TimeUnit.MILLISECONDS);
        }
        OutputStream stdin = process.getOutputStream();
        Thread inThread = null;
        AtomicBoolean finished = new AtomicBoolean(false);
        try (InputStream out = process.getInputStream();
             InputStream err = process.getErrorStream();){
            Thread outThread = new Thread(this.collector(out, stdout), "Write Output Thread");
            outThread.setDaemon(true);
            Thread errThread = new Thread(this.collector(err, stderr), "Write Error Thread");
            errThread.setDaemon(true);
            outThread.start();
            errThread.start();
            if (in != null) {
                if (systemIn || this.useThreadForInput) {
                    inThread = new Thread(() -> {
                        try {
                            while (!finished.get()) {
                                int n = in.available();
                                if (n == 0) {
                                    Thread.sleep(100L);
                                    continue;
                                }
                                int c = in.read();
                                if (c < 0) {
                                    break;
                                }
                                stdin.write(c);
                                if (c != 10) continue;
                                stdin.flush();
                            }
                        }
                        catch (InterruptedIOException n) {
                        }
                        catch (Exception e) {
                            logger.debug("stdin copy exception in thread", (Throwable)e);
                        }
                        finally {
                            IO.close(stdin);
                        }
                    }, "Read Input Thread");
                    inThread.setDaemon(true);
                    inThread.start();
                } else {
                    try {
                        IO.copy(in, stdin);
                    }
                    catch (Exception e) {
                        logger.debug("stdin copy exception", (Throwable)e);
                    }
                    finally {
                        IO.close(stdin);
                    }
                }
            }
            logger.debug("exited process");
            errThread.join();
            outThread.join();
            logger.debug("stdout/stderr streams have finished");
        }
        finally {
            if (scheduler != null) {
                scheduler.shutdownNow();
            }
            Runtime.getRuntime().removeShutdownHook(hook);
        }
        int exitValue = process.waitFor();
        finished.set(true);
        if (inThread != null) {
            if (!systemIn) {
                IO.close(in);
            }
            inThread.interrupt();
        }
        logger.debug("cmd {} executed with result={}, result: {}/{}, timedout={}", new Object[]{this.getArguments(), exitValue, stdout, stderr, this.timedout});
        if (this.timedout) {
            return 123;
        }
        return exitValue;
    }

    public void add(String arg) {
        this.arguments.add(arg);
    }

    public void add(String ... args) {
        Collections.addAll(this.arguments, args);
    }

    public void addAll(Collection<String> args) {
        this.arguments.addAll(args);
    }

    public void setTimeout(long duration, TimeUnit unit) {
        this.timeout = unit.toMillis(duration);
    }

    public void setTrace() {
        this.trace = true;
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public void setCwd(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Working directory must be a directory: " + dir);
        }
        this.cwd = dir;
    }

    public void cancel() {
        this.process.destroy();
    }

    private Runnable collector(InputStream in, Appendable sb) {
        return () -> {
            try {
                int c;
                while ((c = in.read()) >= 0) {
                    sb.append((char)c);
                }
            }
            catch (IOException c) {
            }
            catch (Exception e) {
                try {
                    sb.append("\n**************************************\n");
                    sb.append(e.toString());
                    sb.append("\n**************************************\n");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                logger.debug("cmd exec", (Throwable)e);
            }
        };
    }

    public Command var(String name, String value) {
        this.variables.put(name, value);
        return this;
    }

    public Command arg(String arg) {
        this.add(arg);
        return this;
    }

    public Command arg(String ... args) {
        this.add(args);
        return this;
    }

    public Command full(String full) {
        this.arguments.clear();
        new QuotedTokenizer(full, " \t", false, true).stream().filter(token -> !token.isEmpty()).forEachOrdered(this::add);
        return this;
    }

    public void inherit() {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        this.var(pb.environment());
    }

    public String var(String name) {
        return this.variables.get(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (String argument : this.getArguments()) {
            sb.append(del);
            sb.append(argument);
            del = " ";
        }
        return sb.toString();
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setUseThreadForInput(boolean useThreadForInput) {
        this.useThreadForInput = useThreadForInput;
    }

    public void var(Map<String, String> env) {
        for (Map.Entry<String, String> e : env.entrySet()) {
            this.var(e.getKey(), e.getValue());
        }
    }
}

