/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import com.cloudera.api.swagger.client.ApiClient;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.knox.gateway.config.ConfigurationException;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.auth.AuthUtils;
import org.apache.knox.gateway.topology.discovery.cm.auth.DoAsQueryParameterInterceptor;
import org.apache.knox.gateway.topology.discovery.cm.auth.SpnegoAuthInterceptor;
import org.apache.knox.gateway.util.TruststoreSSLContextUtils;

public class DiscoveryApiClient
extends ApiClient {
    private ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);
    private final ServiceDiscoveryConfig config;
    private static final String API_PATH_PREFIX = "api/";
    private static final String DEFAULT_USER_ALIAS = "cm.discovery.user";
    private static final String DEFAULT_PWD_ALIAS = "cm.discovery.password";

    public DiscoveryApiClient(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig, AliasService aliasService, KeyStore trustStore) {
        this.config = discoveryConfig;
        this.configure(gatewayConfig, aliasService, trustStore);
    }

    ServiceDiscoveryConfig getConfig() {
        return this.config;
    }

    boolean isKerberos() {
        return Boolean.getBoolean("gateway.hadoop.kerberos.secured");
    }

    Subject getKerberosSubject() {
        return AuthUtils.getKerberosSubject();
    }

    private void configure(GatewayConfig gatewayConfig, AliasService aliasService, KeyStore trustStore) {
        String apiAddress = this.getApiAddress(this.config, gatewayConfig);
        this.setBasePath(apiAddress);
        String username = this.config.getUser();
        String passwordAlias = this.config.getPasswordAlias();
        String password = null;
        if (username == null) {
            if (aliasService != null) {
                try {
                    char[] defaultUser = aliasService.getPasswordFromAliasForGateway(DEFAULT_USER_ALIAS);
                    if (defaultUser != null) {
                        username = new String(defaultUser);
                    }
                }
                catch (AliasServiceException e) {
                    this.log.aliasServiceUserError(DEFAULT_USER_ALIAS, e.getLocalizedMessage());
                }
            }
            if (username == null) {
                this.log.aliasServiceUserNotFound();
                throw new ConfigurationException("No username is configured for Cloudera Manager service discovery.");
            }
        }
        if (aliasService != null) {
            if (passwordAlias == null) {
                passwordAlias = DEFAULT_PWD_ALIAS;
            }
            try {
                char[] pwd = aliasService.getPasswordFromAliasForGateway(passwordAlias);
                if (pwd != null) {
                    password = new String(pwd);
                }
            }
            catch (AliasServiceException e) {
                this.log.aliasServicePasswordError(passwordAlias, e.getLocalizedMessage());
            }
        }
        this.setUsername(username);
        this.setPassword(password);
        if (password == null) {
            this.log.aliasServicePasswordNotFound();
            if (this.isKerberos()) {
                ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
                Subject subject = this.getKerberosSubject();
                if (subject != null) {
                    interceptors.add(new SpnegoAuthInterceptor(subject));
                }
                interceptors.add(new DoAsQueryParameterInterceptor(username));
                this.configureInterceptors(interceptors);
            }
        }
        this.configureTimeouts(gatewayConfig);
        this.configureSsl(gatewayConfig, trustStore);
    }

    private String getApiPath(GatewayConfig gatewayConfig) {
        if (gatewayConfig == null) {
            return "api/v32";
        }
        return API_PATH_PREFIX + gatewayConfig.getClouderaManagerServiceDiscoveryApiVersion();
    }

    private String getApiAddress(ServiceDiscoveryConfig serviceDiscoveryConfig, GatewayConfig gatewayConfig) {
        String address = serviceDiscoveryConfig.getAddress();
        String apiPath = this.getApiPath(gatewayConfig);
        return address.endsWith("/") ? address + apiPath : address + "/" + apiPath;
    }

    private void configureInterceptors(List<Interceptor> interceptors) {
        OkHttpClient.Builder builder = this.getHttpClient().newBuilder();
        interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)builder).addInterceptor(arg_0));
        this.setHttpClient(builder.build());
    }

    private void configureTimeouts(GatewayConfig config) {
        OkHttpClient.Builder builder = this.getHttpClient().newBuilder();
        builder.connectTimeout(config.getClouderaManagerServiceDiscoveryConnectTimeoutMillis(), TimeUnit.MILLISECONDS);
        builder.readTimeout(config.getClouderaManagerServiceDiscoveryReadTimeoutMillis(), TimeUnit.MILLISECONDS);
        builder.writeTimeout(config.getClouderaManagerServiceDiscoveryWriteTimeoutMillis(), TimeUnit.MILLISECONDS);
        OkHttpClient client = builder.build();
        this.setHttpClient(client);
        this.log.discoveryClientTimeout(client.connectTimeoutMillis(), client.readTimeoutMillis(), client.writeTimeoutMillis());
    }

    private void configureSsl(GatewayConfig gatewayConfig, KeyStore trustStore) {
        SSLContext truststoreSSLContext = TruststoreSSLContextUtils.getTruststoreSSLContext((KeyStore)trustStore);
        X509TrustManager trustManager = TruststoreSSLContextUtils.getTrustManager((KeyStore)trustStore);
        if (truststoreSSLContext != null && trustManager != null) {
            ConnectionSpec.Builder connectionSpecBuilder = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS);
            List includedSslCiphers = gatewayConfig.getIncludedSSLCiphers();
            if (includedSslCiphers == null || includedSslCiphers.isEmpty()) {
                connectionSpecBuilder.cipherSuites(truststoreSSLContext.getSupportedSSLParameters().getCipherSuites());
            } else {
                connectionSpecBuilder.cipherSuites(includedSslCiphers.toArray(new String[0]));
            }
            Set includedSslProtocols = gatewayConfig.getIncludedSSLProtocols();
            if (includedSslProtocols.isEmpty()) {
                connectionSpecBuilder.tlsVersions(truststoreSSLContext.getSupportedSSLParameters().getProtocols());
            } else {
                connectionSpecBuilder.tlsVersions(includedSslProtocols.toArray(new String[0]));
            }
            OkHttpClient.Builder builder = this.getHttpClient().newBuilder();
            builder.connectionSpecs(Arrays.asList(connectionSpecBuilder.build()));
            builder.sslSocketFactory(truststoreSSLContext.getSocketFactory(), trustManager);
            this.setHttpClient(builder.build());
        } else {
            this.log.failedToConfigureTruststore();
        }
    }
}

