/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.entry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaUtils;
import org.apache.directory.api.util.EmptyEnumeration;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.entry.ServerSearchResult;
import org.apache.directory.server.core.api.interceptor.context.FilteringOperationContext;
import org.apache.directory.server.i18n.I18n;

public final class ServerEntryUtils {
    private ServerEntryUtils() {
    }

    public static javax.naming.directory.Attribute toBasicAttribute(Attribute entryAttribute) {
        AttributeType attributeType = entryAttribute.getAttributeType();
        BasicAttribute attribute = new BasicAttribute(attributeType.getName());
        for (Value value : entryAttribute) {
            if (attributeType.isHR()) {
                attribute.add(value.getString());
                continue;
            }
            attribute.add(value.getBytes());
        }
        return attribute;
    }

    public static Attributes toBasicAttributes(Entry entry) {
        if (entry == null) {
            return null;
        }
        BasicAttributes attributes = new BasicAttributes(true);
        for (Attribute attribute : entry.getAttributes()) {
            AttributeType attributeType = attribute.getAttributeType();
            Attribute attr = entry.get(attributeType);
            if (attributeType.getOid().equals("2.5.4.0") && attr.size() == 0) continue;
            attributes.put(ServerEntryUtils.toBasicAttribute(attr));
        }
        return attributes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Attribute toServerAttribute(javax.naming.directory.Attribute attribute, AttributeType attributeType) throws LdapException {
        if (attribute == null) {
            return null;
        }
        try {
            DefaultAttribute serverAttribute = new DefaultAttribute(attributeType);
            NamingEnumeration<?> values = attribute.getAll();
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                int nbAdded = 0;
                if (value == null) continue;
                if (serverAttribute.isHumanReadable()) {
                    if (value instanceof String) {
                        nbAdded = serverAttribute.add(new String[]{(String)value});
                    } else {
                        if (!(value instanceof byte[])) throw new LdapInvalidAttributeTypeException();
                        nbAdded = serverAttribute.add(new String[]{Strings.utf8ToString((byte[])((byte[])value))});
                    }
                } else if (value instanceof String) {
                    nbAdded = serverAttribute.add((byte[][])new byte[][]{Strings.getBytesUtf8((String)((String)value))});
                } else {
                    if (!(value instanceof byte[])) throw new LdapInvalidAttributeTypeException();
                    nbAdded = serverAttribute.add((byte[][])new byte[][]{(byte[])value});
                }
                if (nbAdded != 0) continue;
                throw new LdapInvalidAttributeTypeException();
            }
            return serverAttribute;
        }
        catch (NamingException ne) {
            throw new LdapInvalidAttributeTypeException();
        }
    }

    public static Entry toServerEntry(Attributes attributes, Dn dn, SchemaManager schemaManager) throws LdapInvalidAttributeTypeException {
        if (attributes instanceof BasicAttributes) {
            try {
                DefaultEntry entry = new DefaultEntry(schemaManager, dn);
                NamingEnumeration<? extends javax.naming.directory.Attribute> attrs = attributes.getAll();
                while (attrs.hasMoreElements()) {
                    javax.naming.directory.Attribute attr = (javax.naming.directory.Attribute)attrs.nextElement();
                    String attributeId = attr.getID();
                    String id = SchemaUtils.stripOptions((String)attributeId);
                    Set options = SchemaUtils.getOptions((String)attributeId);
                    AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(id);
                    Attribute serverAttribute = ServerEntryUtils.toServerAttribute(attr, attributeType);
                    if (serverAttribute == null) continue;
                    entry.put(new Attribute[]{serverAttribute});
                }
                return entry;
            }
            catch (LdapException ne) {
                throw new LdapInvalidAttributeTypeException(ne.getLocalizedMessage());
            }
        }
        return null;
    }

    public static Entry getTargetEntry(Modification mod, Entry entry, SchemaManager schemaManager) throws LdapException {
        Entry targetEntry = entry.clone();
        ModificationOperation modOp = mod.getOperation();
        String id = mod.getAttribute().getUpId();
        AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(id);
        switch (modOp) {
            case REPLACE_ATTRIBUTE: {
                targetEntry.put(new Attribute[]{mod.getAttribute()});
                break;
            }
            case REMOVE_ATTRIBUTE: {
                Attribute toBeRemoved = mod.getAttribute();
                if (toBeRemoved.size() == 0) {
                    targetEntry.removeAttributes(new String[]{id});
                    break;
                }
                Attribute existing = targetEntry.get(id);
                if (existing == null) break;
                for (Value value : toBeRemoved) {
                    existing.remove(new Value[]{value});
                }
                break;
            }
            case ADD_ATTRIBUTE: {
                DefaultAttribute combined = new DefaultAttribute(id, attributeType);
                Attribute toBeAdded = mod.getAttribute();
                Attribute existing = entry.get(id);
                if (existing != null) {
                    for (Value value : existing) {
                        combined.add(new Value[]{value});
                    }
                }
                for (Value value : toBeAdded) {
                    combined.add(new Value[]{value});
                }
                targetEntry.put(new Attribute[]{combined});
                break;
            }
            default: {
                throw new IllegalStateException(I18n.err((I18n)I18n.ERR_464, (Object[])new Object[]{modOp}));
            }
        }
        return targetEntry;
    }

    public static Attribute getUnion(Attribute attr0, Attribute attr1) throws LdapException {
        if (attr0 == null && attr1 == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_465, (Object[])new Object[0]));
        }
        if (attr0 == null) {
            return attr1.clone();
        }
        if (attr1 == null) {
            return attr0.clone();
        }
        if (!attr0.getAttributeType().equals((Object)attr1.getAttributeType())) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_466, (Object[])new Object[0]));
        }
        Attribute attr = attr0.clone();
        for (Value value : attr1) {
            attr.add(new Value[]{value});
        }
        return attr;
    }

    private static Modification toServerModification(ModificationItem modificationImpl, AttributeType attributeType) throws LdapException {
        ModificationOperation operation;
        switch (modificationImpl.getModificationOp()) {
            case 3: {
                operation = ModificationOperation.REMOVE_ATTRIBUTE;
                break;
            }
            case 2: {
                operation = ModificationOperation.REPLACE_ATTRIBUTE;
                break;
            }
            default: {
                operation = ModificationOperation.ADD_ATTRIBUTE;
            }
        }
        return new DefaultModification(operation, ServerEntryUtils.toServerAttribute(modificationImpl.getAttribute(), attributeType));
    }

    public static List<Modification> convertToServerModification(List<ModificationItem> modificationItems, SchemaManager schemaManager) throws LdapException {
        if (modificationItems != null) {
            ArrayList<Modification> modifications = new ArrayList<Modification>(modificationItems.size());
            for (ModificationItem modificationItem : modificationItems) {
                AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(modificationItem.getAttribute().getID());
                modifications.add(ServerEntryUtils.toServerModification(modificationItem, attributeType));
            }
            return modifications;
        }
        return null;
    }

    private static Modification toServerModification(Modification modification, AttributeType attributeType) throws LdapException {
        return new DefaultModification(modification.getOperation(), (Attribute)new DefaultAttribute(attributeType, modification.getAttribute()));
    }

    public static List<Modification> toServerModification(Modification[] modifications, SchemaManager schemaManager) throws LdapException {
        if (modifications != null) {
            ArrayList<Modification> modificationsList = new ArrayList<Modification>();
            for (Modification modification : modifications) {
                String attributeId = modification.getAttribute().getUpId();
                String id = ServerEntryUtils.stripOptions(attributeId);
                modification.getAttribute().setUpId(id);
                Set<String> options = ServerEntryUtils.getOptions(attributeId);
                if (!schemaManager.getAttributeTypeRegistry().contains(id) && modification.getAttribute().size() == 0 && modification.getOperation() == ModificationOperation.REPLACE_ATTRIBUTE) {
                    String message = I18n.err((I18n)I18n.ERR_467, (Object[])new Object[]{id});
                    throw new LdapInvalidAttributeTypeException(message);
                }
                AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(id);
                modificationsList.add(ServerEntryUtils.toServerModification(modification, attributeType));
            }
            return modificationsList;
        }
        return null;
    }

    public static List<Modification> toServerModification(ModificationItem[] modifications, SchemaManager schemaManager) throws LdapException {
        if (modifications != null) {
            ArrayList<Modification> modificationsList = new ArrayList<Modification>();
            for (ModificationItem modification : modifications) {
                String attributeId = modification.getAttribute().getID();
                String id = ServerEntryUtils.stripOptions(attributeId);
                Set<String> options = ServerEntryUtils.getOptions(attributeId);
                if (!schemaManager.getAttributeTypeRegistry().contains(id) && modification.getAttribute().size() == 0 && modification.getModificationOp() == 2) continue;
                AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(id);
                modificationsList.add(ServerEntryUtils.toServerModification(modification, attributeType));
            }
            return modificationsList;
        }
        return null;
    }

    public static Modification getModificationItem(List<Modification> mods, AttributeType type) {
        for (Modification modification : mods) {
            Attribute attribute = modification.getAttribute();
            if (attribute.getAttributeType() != type) continue;
            return modification;
        }
        return null;
    }

    public static Attribute getAttribute(List<Modification> mods, AttributeType type) {
        Modification mod = ServerEntryUtils.getModificationItem(mods, type);
        if (mod != null) {
            return mod.getAttribute();
        }
        return null;
    }

    public static NamingEnumeration<SearchResult> toSearchResultEnum(final NamingEnumeration<ServerSearchResult> result) {
        if (result instanceof EmptyEnumeration) {
            return new EmptyEnumeration();
        }
        return new NamingEnumeration<SearchResult>(){

            @Override
            public void close() throws NamingException {
                result.close();
            }

            @Override
            public boolean hasMore() throws NamingException {
                return result.hasMore();
            }

            @Override
            public SearchResult next() throws NamingException {
                ServerSearchResult rec = (ServerSearchResult)result.next();
                return new SearchResult(rec.getDn().getName(), rec.getObject(), ServerEntryUtils.toBasicAttributes(rec.getServerEntry()), rec.isRelative());
            }

            @Override
            public boolean hasMoreElements() {
                return result.hasMoreElements();
            }

            @Override
            public SearchResult nextElement() {
                try {
                    ServerSearchResult rec = (ServerSearchResult)result.next();
                    return new SearchResult(rec.getDn().getName(), rec.getObject(), ServerEntryUtils.toBasicAttributes(rec.getServerEntry()), rec.isRelative());
                }
                catch (NamingException ne) {
                    NoSuchElementException nsee = new NoSuchElementException(I18n.err((I18n)I18n.ERR_468, (Object[])new Object[0]));
                    nsee.initCause(ne);
                    throw nsee;
                }
            }
        };
    }

    private static String stripOptions(String attributeId) {
        int optionsPos = attributeId.indexOf(59);
        if (optionsPos != -1) {
            return attributeId.substring(0, optionsPos);
        }
        return attributeId;
    }

    private static Set<String> getOptions(String attributeId) {
        int optionsPos = attributeId.indexOf(59);
        if (optionsPos != -1) {
            String[] res;
            HashSet<String> options = new HashSet<String>();
            for (String option : res = attributeId.substring(optionsPos + 1).split(";")) {
                if (Strings.isEmpty((String)option)) continue;
                options.add(option);
            }
            return options;
        }
        return null;
    }

    public static void filterContents(SchemaManager schemaManager, FilteringOperationContext operationContext, Entry entry) throws LdapException {
        boolean returnAll;
        boolean typesOnly = operationContext.isTypesOnly();
        boolean bl = returnAll = operationContext.isAllOperationalAttributes() && operationContext.isAllUserAttributes() && !typesOnly;
        if (returnAll) {
            return;
        }
        Entry originalEntry = ((ClonedServerEntry)entry).getOriginalEntry();
        AttributeType entryDnType = schemaManager.lookupAttributeTypeRegistry("1.3.6.1.1.20");
        AttributeType refType = schemaManager.lookupAttributeTypeRegistry("2.16.840.1.113730.3.1.34");
        if (operationContext.isNoAttributes()) {
            for (Attribute attribute : originalEntry) {
                AttributeType attributeType = attribute.getAttributeType();
                if (operationContext.isReferralThrown() && attributeType.equals((Object)refType)) continue;
                entry.remove(new Attribute[]{entry.get(attributeType)});
            }
            entry.removeAttributes(new AttributeType[]{entryDnType});
            return;
        }
        if (operationContext.isAllUserAttributes()) {
            for (Attribute attribute : originalEntry) {
                AttributeType attributeType = attribute.getAttributeType();
                if (operationContext.isReferralThrown() && attributeType.equals((Object)refType)) continue;
                if (attributeType.isOperational()) {
                    if (!operationContext.contains(schemaManager, attributeType)) {
                        entry.removeAttributes(new AttributeType[]{attributeType});
                        continue;
                    }
                    if (!typesOnly) continue;
                    entry.get(attributeType).clear();
                    continue;
                }
                if (!typesOnly) continue;
                entry.get(attributeType).clear();
            }
            if (!operationContext.contains(schemaManager, entryDnType)) {
                entry.removeAttributes(new AttributeType[]{entryDnType});
            }
            return;
        }
        if (operationContext.isAllOperationalAttributes()) {
            for (Attribute attribute : originalEntry) {
                AttributeType attributeType = attribute.getAttributeType();
                if (attributeType.isUser()) {
                    if (!operationContext.contains(schemaManager, attributeType)) {
                        entry.removeAttributes(new AttributeType[]{attributeType});
                        continue;
                    }
                    if (!typesOnly) continue;
                    entry.get(attributeType).clear();
                    continue;
                }
                if (!typesOnly) continue;
                entry.get(attributeType).clear();
            }
            if (!operationContext.contains(schemaManager, entryDnType)) {
                entry.removeAttributes(new AttributeType[]{entryDnType});
            } else if (typesOnly) {
                entry.get(entryDnType).clear();
            }
            return;
        }
        if (operationContext.getReturningAttributes() != null) {
            for (Attribute attribute : originalEntry) {
                AttributeType attributeType = attribute.getAttributeType();
                if (operationContext.isReferralThrown() && attributeType.equals((Object)refType)) continue;
                if (!operationContext.contains(schemaManager, attributeType)) {
                    entry.removeAttributes(new AttributeType[]{attributeType});
                    continue;
                }
                boolean isNotRequested = true;
                for (AttributeTypeOptions attrOptions : operationContext.getReturningAttributes()) {
                    if (!attrOptions.getAttributeType().equals((Object)attributeType) && !attrOptions.getAttributeType().isAncestorOf(attributeType)) continue;
                    isNotRequested = false;
                    break;
                }
                if (isNotRequested) {
                    entry.removeAttributes(new AttributeType[]{attributeType});
                    continue;
                }
                if (!typesOnly) continue;
                entry.get(attributeType).clear();
            }
            if (!operationContext.contains(schemaManager, entryDnType)) {
                entry.removeAttributes(new AttributeType[]{entryDnType});
            } else if (typesOnly) {
                entry.get(entryDnType).clear();
            }
        }
    }
}

