/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitGreaterOrEqualFilter
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitGreaterOrEqualFilter.class);

    public InitGreaterOrEqualFilter() {
        super("Initialize Greater Or Equal filter");
    }

    public void action(LdapMessageContainer<SearchRequest> container) throws DecoderException {
        AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(container.getCurrentTLV().getId(), 1);
        container.addCurrentFilter(filter);
        container.setTerminalFilter(filter);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05147_INITIALIZE_GEQ_FILTER, (Object[])new Object[0]));
        }
    }
}

