/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.server.servlet;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.server.servlet.OAuth2AuthorizationServerProperties;
import org.springframework.boot.autoconfigure.security.oauth2.server.servlet.OAuth2AuthorizationServerPropertiesMapper;
import org.springframework.boot.autoconfigure.security.oauth2.server.servlet.RegisteredClientsConfiguredCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.server.authorization.client.InMemoryRegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OAuth2AuthorizationServerProperties.class})
class OAuth2AuthorizationServerConfiguration {
    private final OAuth2AuthorizationServerPropertiesMapper propertiesMapper;

    OAuth2AuthorizationServerConfiguration(OAuth2AuthorizationServerProperties properties) {
        this.propertiesMapper = new OAuth2AuthorizationServerPropertiesMapper(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={RegisteredClientsConfiguredCondition.class})
    RegisteredClientRepository registeredClientRepository() {
        return new InMemoryRegisteredClientRepository(this.propertiesMapper.asRegisteredClients());
    }

    @Bean
    @ConditionalOnMissingBean
    AuthorizationServerSettings authorizationServerSettings() {
        return this.propertiesMapper.asAuthorizationServerSettings();
    }
}

