/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.registry;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.RegistryBucketsResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.entity.FlowRegistryBucketsEntity;

public class ListBuckets
extends AbstractNiFiCommand<RegistryBucketsResult> {
    public ListBuckets() {
        super("list-buckets", RegistryBucketsResult.class);
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.REGISTRY_CLIENT_ID.createOption());
        this.addOption(CommandOption.FLOW_BRANCH.createOption());
    }

    @Override
    public String getDescription() {
        return "Returns the list of branches seen by the specified registry client.";
    }

    @Override
    public RegistryBucketsResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String regClientId = this.getRequiredArg(properties, CommandOption.REGISTRY_CLIENT_ID);
        String branchName = this.getRequiredArg(properties, CommandOption.FLOW_BRANCH);
        FlowRegistryBucketsEntity buckets = client.getFlowClient().getFlowRegistryBuckets(regClientId, branchName);
        return new RegistryBucketsResult(this.getResultType(properties), buckets);
    }
}

