/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class UsernamePasswordAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 620L;
    private final @Nullable Object principal;
    private @Nullable Object credentials;

    public UsernamePasswordAuthenticationToken(@Nullable Object principal, @Nullable Object credentials) {
        super((Collection<? extends GrantedAuthority>)null);
        this.principal = principal;
        this.credentials = credentials;
        this.setAuthenticated(false);
    }

    public UsernamePasswordAuthenticationToken(Object principal, @Nullable Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        this.credentials = credentials;
        super.setAuthenticated(true);
    }

    protected UsernamePasswordAuthenticationToken(Builder<?> builder) {
        super(builder);
        this.principal = builder.principal;
        this.credentials = builder.credentials;
    }

    public static UsernamePasswordAuthenticationToken unauthenticated(@Nullable Object principal, @Nullable Object credentials) {
        return new UsernamePasswordAuthenticationToken(principal, credentials);
    }

    public static UsernamePasswordAuthenticationToken authenticated(Object principal, @Nullable Object credentials, Collection<? extends GrantedAuthority> authorities) {
        return new UsernamePasswordAuthenticationToken(principal, credentials, authorities);
    }

    @Override
    public @Nullable Object getCredentials() {
        return this.credentials;
    }

    @Override
    public @Nullable Object getPrincipal() {
        return this.principal;
    }

    @Override
    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        Assert.isTrue((!isAuthenticated ? 1 : 0) != 0, (String)"Cannot set this token to trusted - use constructor which takes a GrantedAuthority list instead");
        super.setAuthenticated(false);
    }

    @Override
    public void eraseCredentials() {
        super.eraseCredentials();
        this.credentials = null;
    }

    public Builder<?> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAuthenticationToken.AbstractAuthenticationBuilder<B> {
        private @Nullable Object principal;
        private @Nullable Object credentials;

        protected Builder(UsernamePasswordAuthenticationToken token) {
            super(token);
            this.principal = token.principal;
            this.credentials = token.credentials;
        }

        @Override
        public B principal(@Nullable Object principal) {
            Assert.notNull((Object)principal, (String)"principal cannot be null");
            this.principal = principal;
            return (B)this;
        }

        @Override
        public B credentials(@Nullable Object credentials) {
            this.credentials = credentials;
            return (B)this;
        }

        @Override
        public UsernamePasswordAuthenticationToken build() {
            return new UsernamePasswordAuthenticationToken(this);
        }
    }
}

