/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.SimpleAuthentication;

public interface Authentication
extends Principal,
Serializable {
    public Collection<? extends GrantedAuthority> getAuthorities();

    public @Nullable Object getCredentials();

    public @Nullable Object getDetails();

    public @Nullable Object getPrincipal();

    public boolean isAuthenticated();

    public void setAuthenticated(boolean var1) throws IllegalArgumentException;

    default public Builder<?> toBuilder() {
        return new SimpleAuthentication.Builder(this);
    }

    public static interface Builder<B extends Builder<B>> {
        public B authorities(Consumer<Collection<GrantedAuthority>> var1);

        default public B credentials(@Nullable Object credentials) {
            throw new UnsupportedOperationException(String.format("%s does not store credentials", this.getClass().getSimpleName()));
        }

        public B details(@Nullable Object var1);

        public B principal(@Nullable Object var1);

        public B authenticated(boolean var1);

        public Authentication build();
    }
}

