/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.RewriteTablePathUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;

public class ContentFileUtil {
    private static final int PATH_ID = MetadataColumns.DELETE_FILE_PATH.fieldId();
    private static final Type PATH_TYPE = MetadataColumns.DELETE_FILE_PATH.type();

    private ContentFileUtil() {
    }

    public static <F extends ContentFile<K>, K> K copy(F file, boolean withStats, Set<Integer> requestedColumnIds) {
        if (withStats) {
            return (K)(requestedColumnIds != null ? file.copyWithStats(requestedColumnIds) : file.copy());
        }
        return (K)file.copyWithoutStats();
    }

    public static CharSequence referencedDataFile(DeleteFile deleteFile) {
        ByteBuffer upperPathBound;
        ByteBuffer lowerPathBound;
        if (deleteFile.content() == FileContent.EQUALITY_DELETES) {
            return null;
        }
        if (deleteFile.referencedDataFile() != null) {
            return deleteFile.referencedDataFile();
        }
        Map lowerBounds = deleteFile.lowerBounds();
        ByteBuffer byteBuffer = lowerPathBound = lowerBounds != null ? (ByteBuffer)lowerBounds.get(PATH_ID) : null;
        if (lowerPathBound == null) {
            return null;
        }
        Map upperBounds = deleteFile.upperBounds();
        ByteBuffer byteBuffer2 = upperPathBound = upperBounds != null ? (ByteBuffer)upperBounds.get(PATH_ID) : null;
        if (upperPathBound == null) {
            return null;
        }
        if (lowerPathBound.equals(upperPathBound)) {
            return (CharSequence)Conversions.fromByteBuffer((Type)PATH_TYPE, (ByteBuffer)lowerPathBound);
        }
        return null;
    }

    public static Metrics replacePathBounds(DeleteFile deleteFile, String sourcePrefix, String targetPrefix) {
        ByteBuffer upperPathBound;
        ByteBuffer lowerPathBound;
        Preconditions.checkArgument((deleteFile.content() == FileContent.POSITION_DELETES ? 1 : 0) != 0, (Object)"Only position delete files supported");
        Map lowerBounds = deleteFile.lowerBounds();
        ByteBuffer byteBuffer = lowerPathBound = lowerBounds != null ? (ByteBuffer)lowerBounds.get(PATH_ID) : null;
        if (lowerPathBound == null) {
            return ContentFileUtil.metricsWithoutPathBounds(deleteFile);
        }
        Map upperBounds = deleteFile.upperBounds();
        ByteBuffer byteBuffer2 = upperPathBound = upperBounds != null ? (ByteBuffer)upperBounds.get(PATH_ID) : null;
        if (upperPathBound == null) {
            return ContentFileUtil.metricsWithoutPathBounds(deleteFile);
        }
        if (lowerPathBound.equals(upperPathBound)) {
            CharBuffer path = (CharBuffer)Conversions.fromByteBuffer((Type)PATH_TYPE, (ByteBuffer)lowerPathBound);
            CharBuffer newPath = CharBuffer.wrap(RewriteTablePathUtil.newPath(path.toString(), sourcePrefix, targetPrefix));
            ByteBuffer newBytes = Conversions.toByteBuffer((Type)PATH_TYPE, (Object)newPath);
            return ContentFileUtil.metricsWithPathBounds(deleteFile, newBytes);
        }
        return ContentFileUtil.metricsWithoutPathBounds(deleteFile);
    }

    public static String referencedDataFileLocation(DeleteFile deleteFile) {
        CharSequence location = ContentFileUtil.referencedDataFile(deleteFile);
        return location != null ? location.toString() : null;
    }

    public static boolean isFileScoped(DeleteFile deleteFile) {
        return ContentFileUtil.referencedDataFile(deleteFile) != null;
    }

    public static boolean isDV(DeleteFile deleteFile) {
        return deleteFile.format() == FileFormat.PUFFIN;
    }

    public static boolean containsSingleDV(Iterable<DeleteFile> deleteFiles) {
        return Iterables.size(deleteFiles) == 1 && Iterables.all(deleteFiles, ContentFileUtil::isDV);
    }

    public static String dvDesc(DeleteFile deleteFile) {
        return String.format("DV{location=%s, offset=%s, length=%s, referencedDataFile=%s}", deleteFile.location(), deleteFile.contentOffset(), deleteFile.contentSizeInBytes(), deleteFile.referencedDataFile());
    }

    private static Metrics metricsWithoutPathBounds(DeleteFile file) {
        HashMap upperBounds;
        HashMap lowerBounds = file.lowerBounds() == null ? null : Maps.newHashMap((Map)file.lowerBounds());
        HashMap hashMap = upperBounds = file.upperBounds() == null ? null : Maps.newHashMap((Map)file.upperBounds());
        if (lowerBounds != null) {
            lowerBounds.remove(PATH_ID);
        }
        if (upperBounds != null) {
            upperBounds.remove(PATH_ID);
        }
        return new Metrics(Long.valueOf(file.recordCount()), file.columnSizes(), file.valueCounts(), file.nullValueCounts(), file.nanValueCounts(), lowerBounds == null ? null : Collections.unmodifiableMap(lowerBounds), upperBounds == null ? null : Collections.unmodifiableMap(upperBounds));
    }

    private static Metrics metricsWithPathBounds(DeleteFile file, ByteBuffer bound) {
        HashMap upperBounds;
        HashMap lowerBounds = file.lowerBounds() == null ? null : Maps.newHashMap((Map)file.lowerBounds());
        HashMap hashMap = upperBounds = file.upperBounds() == null ? null : Maps.newHashMap((Map)file.upperBounds());
        if (lowerBounds != null) {
            lowerBounds.put(PATH_ID, bound);
        }
        if (upperBounds != null) {
            upperBounds.put(PATH_ID, bound);
        }
        return new Metrics(Long.valueOf(file.recordCount()), file.columnSizes(), file.valueCounts(), file.nullValueCounts(), file.nanValueCounts(), lowerBounds == null ? null : Collections.unmodifiableMap(lowerBounds), upperBounds == null ? null : Collections.unmodifiableMap(upperBounds));
    }
}

