/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class DisableableConfigSource
implements ConfigSource {
    private final ConfigSource source;
    private final ConfigSource emptySource;
    private AtomicReference<ConfigSource> activeSource;

    public DisableableConfigSource(final ConfigSource source) {
        this.source = source;
        this.emptySource = new ConfigSource(){

            public Set<String> getPropertyNames() {
                return Collections.emptySet();
            }

            public String getValue(String propertyName) {
                return null;
            }

            public String getName() {
                return source.getName();
            }

            public int getOrdinal() {
                return source.getOrdinal();
            }
        };
        this.activeSource = new AtomicReference<ConfigSource>(source);
    }

    public Map<String, String> getProperties() {
        return this.activeSource.get().getProperties();
    }

    public Set<String> getPropertyNames() {
        return this.activeSource.get().getPropertyNames();
    }

    public int getOrdinal() {
        return this.source.getOrdinal();
    }

    public String getValue(String propertyName) {
        return this.activeSource.get().getValue(propertyName);
    }

    public String getName() {
        return this.source.getName();
    }

    public void enable() {
        this.activeSource.compareAndSet(this.emptySource, this.source);
    }

    public void disable() {
        this.activeSource.compareAndSet(this.source, this.emptySource);
    }
}

