/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.example;

import java.io.IOException;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;
import org.apache.rocketmq.client.apis.StaticSessionCredentialsProvider;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.consumer.LitePushConsumer;
import org.apache.rocketmq.client.java.exception.LiteSubscriptionQuotaExceededException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LitePushConsumerExample {
    private static final Logger log = LoggerFactory.getLogger(LitePushConsumerExample.class);

    private LitePushConsumerExample() {
    }

    public static void main(String[] args) throws ClientException, InterruptedException, IOException {
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        String accessKey = "yourAccessKey";
        String secretKey = "yourSecretKey";
        StaticSessionCredentialsProvider sessionCredentialsProvider = new StaticSessionCredentialsProvider(accessKey, secretKey);
        String endpoints = "foobar.com:8080";
        ClientConfiguration clientConfiguration = ClientConfiguration.newBuilder().setEndpoints(endpoints).setCredentialProvider((SessionCredentialsProvider)sessionCredentialsProvider).build();
        String consumerGroup = "yourConsumerGroup";
        String topic = "yourParentTopic";
        LitePushConsumer litePushConsumer = provider.newLitePushConsumerBuilder().setClientConfiguration(clientConfiguration).setConsumerGroup(consumerGroup).bindTopic(topic).setMessageListener(messageView -> {
            log.info("Consume message={}", (Object)messageView);
            return ConsumeResult.SUCCESS;
        }).build();
        try {
            litePushConsumer.subscribeLite("lite-topic-1");
            litePushConsumer.subscribeLite("lite-topic-2");
            litePushConsumer.subscribeLite("lite-topic-3");
        }
        catch (LiteSubscriptionQuotaExceededException e) {
            log.error("Lite subscription quota exceeded", (Throwable)((Object)e));
        }
        catch (Throwable t) {
            log.error("Failed to subscribe lite topic", t);
        }
        Thread.sleep(Long.MAX_VALUE);
        litePushConsumer.close();
    }
}

