/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.tracing;

import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.tracing.ScbMarker;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class TraceIdLogger {
    private static final Marker MARKER = new ScbMarker();
    private static final String KEY_TRACE_ID = "SERVICECOMB_TRACE_ID";
    private final Invocation invocation;
    private String name;

    public TraceIdLogger(Invocation invocation) {
        this.invocation = invocation;
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public final String getName() {
        if (this.name == null) {
            this.name = this.invocation.getTraceId() + "-" + this.invocation.getInvocationId();
        }
        return this.name;
    }

    public void error(Logger logger, String format, Object ... arguments) {
        MDC.put((String)KEY_TRACE_ID, (String)this.getName());
        logger.error(MARKER, format, arguments);
        MDC.remove((String)KEY_TRACE_ID);
    }

    public void warn(Logger logger, String format, Object ... arguments) {
        MDC.put((String)KEY_TRACE_ID, (String)this.getName());
        logger.warn(MARKER, format, arguments);
        MDC.remove((String)KEY_TRACE_ID);
    }

    public void info(Logger logger, String format, Object ... arguments) {
        MDC.put((String)KEY_TRACE_ID, (String)this.getName());
        logger.info(MARKER, format, arguments);
        MDC.remove((String)KEY_TRACE_ID);
    }

    public void debug(Logger logger, String format, Object ... arguments) {
        MDC.put((String)KEY_TRACE_ID, (String)this.getName());
        logger.debug(MARKER, format, arguments);
        MDC.remove((String)KEY_TRACE_ID);
    }
}

