/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.internal.shared.Formulas;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public class Envelope2D
extends Rectangle2D.Double
implements Envelope,
Emptiable,
Cloneable {
    private static final long serialVersionUID = 761232175464415062L;
    private static final int DIMENSION = 2;
    private static final Rectangle2D.Double[] EMPTY = new Rectangle2D.Double[0];
    private CoordinateReferenceSystem crs;

    public Envelope2D() {
    }

    private Envelope2D(double xmin, double ymin, double xmax, double ymax) {
        super(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    private Envelope2D(CoordinateReferenceSystem crs, DirectPosition lowerCorner, DirectPosition upperCorner) {
        this(lowerCorner.getOrdinate(0), lowerCorner.getOrdinate(1), upperCorner.getOrdinate(0), upperCorner.getOrdinate(1));
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)2, (CoordinateReferenceSystem)crs);
        this.crs = crs;
    }

    public Envelope2D(DirectPosition lowerCorner, DirectPosition upperCorner) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        this(AbstractEnvelope.getCommonCRS(lowerCorner, upperCorner), lowerCorner, upperCorner);
    }

    public Envelope2D(Envelope envelope) throws MismatchedDimensionException {
        this(envelope.getCoordinateReferenceSystem(), envelope.getLowerCorner(), envelope.getUpperCorner());
    }

    public Envelope2D(GeographicBoundingBox box) {
        this(box.getWestBoundLongitude(), box.getSouthBoundLatitude(), box.getEastBoundLongitude(), box.getNorthBoundLatitude());
        this.crs = CommonCRS.defaultGeographic();
        if (Boolean.FALSE.equals(box.getInclusion())) {
            this.x += this.width;
            this.width = -this.width;
            if (!Formulas.isPoleToPole(this.y, this.y + this.height)) {
                this.y += this.height;
                this.height = -this.height;
            }
        }
    }

    public Envelope2D(CoordinateReferenceSystem crs, Rectangle2D rect) throws MismatchedDimensionException {
        super(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)2, (CoordinateReferenceSystem)crs);
        this.crs = crs;
    }

    public Envelope2D(CoordinateReferenceSystem crs, double x, double y, double width, double height) throws MismatchedDimensionException {
        super(x, y, width, height);
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)2, (CoordinateReferenceSystem)crs);
        this.crs = crs;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)2, (CoordinateReferenceSystem)crs);
        this.crs = crs;
    }

    @Override
    public void setRect(Rectangle2D rect) {
        CoordinateReferenceSystem envelopeCRS;
        if (rect == this) {
            return;
        }
        if (rect instanceof Envelope && (envelopeCRS = ((Envelope)rect).getCoordinateReferenceSystem()) != null) {
            this.setCoordinateReferenceSystem(envelopeCRS);
        }
        super.setRect(rect);
    }

    public final int getDimension() {
        return 2;
    }

    public DirectPosition2D getLowerCorner() {
        return new DirectPosition2D(this.crs, this.x, this.y);
    }

    public DirectPosition2D getUpperCorner() {
        return new DirectPosition2D(this.crs, this.x != 0.0 ? this.x + this.width : this.width, this.y != 0.0 ? this.y + this.height : this.height);
    }

    public DirectPosition2D getMedian() {
        return new DirectPosition2D(this.crs, this.getMedian(0), this.getMedian(1));
    }

    private static IndexOutOfBoundsException indexOutOfBounds(int dimension) {
        return new IndexOutOfBoundsException(Errors.format((short)88, (Object)dimension));
    }

    public double getMinimum(int dimension) throws IndexOutOfBoundsException {
        double span;
        double value;
        switch (dimension) {
            case 0: {
                value = this.x;
                span = this.width;
                break;
            }
            case 1: {
                value = this.y;
                span = this.height;
                break;
            }
            default: {
                throw Envelope2D.indexOutOfBounds(dimension);
            }
        }
        if (MathFunctions.isNegative((double)span)) {
            CoordinateSystemAxis axis = AbstractEnvelope.getAxis(this.crs, dimension);
            return AbstractEnvelope.isWrapAround(axis) ? axis.getMinimumValue() : Double.NaN;
        }
        return value;
    }

    public double getMaximum(int dimension) throws IndexOutOfBoundsException {
        double span;
        double value;
        switch (dimension) {
            case 0: {
                value = this.x;
                span = this.width;
                break;
            }
            case 1: {
                value = this.y;
                span = this.height;
                break;
            }
            default: {
                throw Envelope2D.indexOutOfBounds(dimension);
            }
        }
        if (MathFunctions.isNegative((double)span)) {
            CoordinateSystemAxis axis = AbstractEnvelope.getAxis(this.crs, dimension);
            return AbstractEnvelope.isWrapAround(axis) ? axis.getMaximumValue() : Double.NaN;
        }
        return value + span;
    }

    public double getMedian(int dimension) throws IndexOutOfBoundsException {
        double span;
        double value;
        switch (dimension) {
            case 0: {
                value = this.x;
                span = this.width;
                break;
            }
            case 1: {
                value = this.y;
                span = this.height;
                break;
            }
            default: {
                throw Envelope2D.indexOutOfBounds(dimension);
            }
        }
        value += 0.5 * span;
        if (MathFunctions.isNegative((double)span)) {
            value = AbstractEnvelope.fixMedian(AbstractEnvelope.getAxis(this.crs, dimension), value);
        }
        return value;
    }

    public double getSpan(int dimension) throws IndexOutOfBoundsException {
        double span;
        switch (dimension) {
            case 0: {
                span = this.width;
                break;
            }
            case 1: {
                span = this.height;
                break;
            }
            default: {
                throw Envelope2D.indexOutOfBounds(dimension);
            }
        }
        if (MathFunctions.isNegative((double)span)) {
            span = AbstractEnvelope.fixSpan(AbstractEnvelope.getAxis(this.crs, dimension), span);
        }
        return span;
    }

    @Override
    public double getMinX() {
        return this.getMinimum(0);
    }

    @Override
    public double getMinY() {
        return this.getMinimum(1);
    }

    @Override
    public double getMaxX() {
        return this.getMaximum(0);
    }

    @Override
    public double getMaxY() {
        return this.getMaximum(1);
    }

    @Override
    public double getCenterX() {
        return this.getMedian(0);
    }

    @Override
    public double getCenterY() {
        return this.getMedian(1);
    }

    @Override
    public double getWidth() {
        return this.getSpan(0);
    }

    @Override
    public double getHeight() {
        return this.getSpan(1);
    }

    @Override
    public boolean isEmpty() {
        return !(this.width > 0.0) && (!MathFunctions.isNegative((double)this.width) || !AbstractEnvelope.isWrapAround(this.crs, 0)) || !(this.height > 0.0) && (!MathFunctions.isNegative((double)this.height) || !AbstractEnvelope.isWrapAround(this.crs, 1));
    }

    public Rectangle2D.Double[] toRectangles() {
        Rectangle2D.Double next;
        Rectangle2D.Double start;
        int isWrapAround = 0;
        for (int i = 0; i != 2; ++i) {
            double span;
            double d = span = i == 0 ? this.width : this.height;
            if (span > 0.0) continue;
            if (!MathFunctions.isNegative((double)span) || !AbstractEnvelope.isWrapAround(this.crs, i)) {
                return EMPTY;
            }
            isWrapAround |= 1 << i;
        }
        Rectangle2D.Double[] rect = new Rectangle2D.Double[1 << Integer.bitCount(isWrapAround)];
        for (int i = 0; i < rect.length; ++i) {
            rect[i] = new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }
        if ((isWrapAround & 1) != 0) {
            CoordinateSystemAxis axis = AbstractEnvelope.getAxis(this.crs, 0);
            start = rect[0];
            next = rect[1];
            start.width = axis.getMaximumValue() - this.x;
            next.x = axis.getMinimumValue();
            next.width += this.x - next.x;
        }
        if ((isWrapAround & 2) != 0) {
            CoordinateSystemAxis axis = AbstractEnvelope.getAxis(this.crs, 1);
            start = rect[0];
            next = rect[isWrapAround - 1];
            start.height = axis.getMaximumValue() - this.y;
            next.y = axis.getMinimumValue();
            next.height += this.y - next.y;
        }
        if (isWrapAround == 3) {
            rect[1].height = rect[0].height;
            rect[2].width = rect[0].width;
            rect[3].x = rect[1].x;
            rect[3].width = rect[1].width;
            rect[3].y = rect[2].y;
            rect[3].height = rect[2].height;
        }
        return rect;
    }

    @Override
    public boolean contains(double px, double py) {
        boolean c2;
        boolean c1 = px >= this.x;
        boolean bl = c2 = px <= this.x + this.width;
        if (c1 & c2 || c1 | c2 && MathFunctions.isNegative((double)this.width)) {
            c1 = py >= this.y;
            c2 = py <= this.y + this.height;
            return c1 & c2 || c1 | c2 && MathFunctions.isNegative((double)this.height);
        }
        return false;
    }

    @Override
    public boolean contains(Rectangle2D rect) {
        if (rect instanceof Envelope2D) {
            Envelope2D env = (Envelope2D)rect;
            return this.contains(env.x, env.y, env.width, env.height);
        }
        return super.contains(rect);
    }

    @Override
    public boolean contains(double rx, double ry, double rw, double rh) {
        for (int i = 0; i != 2; ++i) {
            boolean maxCondition;
            double span1;
            double min1;
            double span0;
            double min0;
            if (i == 0) {
                min0 = this.x;
                span0 = this.width;
                min1 = rx;
                span1 = rw;
            } else {
                min0 = this.y;
                span0 = this.height;
                min1 = ry;
                span1 = rh;
            }
            boolean minCondition = min1 >= min0;
            boolean bl = maxCondition = min1 + span1 <= min0 + span0;
            if (minCondition & maxCondition ? !AbstractEnvelope.isNegativeUnsafe(span1) || AbstractEnvelope.isNegativeUnsafe(span0) || span0 >= AbstractEnvelope.getCycle(AbstractEnvelope.getAxis(this.crs, i)) : (minCondition != maxCondition ? MathFunctions.isNegative((double)span0) && MathFunctions.isPositive((double)span1) : MathFunctions.isNegativeZero((double)span0))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(Rectangle2D rect) {
        if (rect instanceof Envelope2D) {
            Envelope2D env = (Envelope2D)rect;
            return this.intersects(env.x, env.y, env.width, env.height);
        }
        return super.intersects(rect);
    }

    @Override
    public boolean intersects(double rx, double ry, double rw, double rh) {
        for (int i = 0; i != 2; ++i) {
            boolean sp1;
            boolean sp0;
            boolean maxCondition;
            double span1;
            double min1;
            double span0;
            double min0;
            if (i == 0) {
                min0 = this.x;
                span0 = this.width;
                min1 = rx;
                span1 = rw;
            } else {
                min0 = this.y;
                span0 = this.height;
                min1 = ry;
                span1 = rh;
            }
            boolean minCondition = min1 < min0 + span0;
            boolean bl = maxCondition = min1 + span1 > min0;
            if (maxCondition & minCondition || (sp0 = MathFunctions.isNegative((double)span0)) | (sp1 = MathFunctions.isNegative((double)span1)) && sp0 & sp1 | (maxCondition | minCondition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Envelope2D createIntersection(Rectangle2D rect) {
        Envelope2D env = rect instanceof Envelope2D ? (Envelope2D)rect : null;
        Envelope2D inter = new Envelope2D(this.crs, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        for (int i = 0; i != 2; ++i) {
            double span1;
            double min1;
            double span0;
            double min0;
            if (i == 0) {
                min0 = this.x;
                span0 = this.width;
                min1 = rect.getX();
                span1 = env != null ? env.width : rect.getWidth();
            } else {
                min0 = this.y;
                span0 = this.height;
                min1 = rect.getY();
                span1 = env != null ? env.height : rect.getHeight();
            }
            double max0 = min0 != 0.0 ? min0 + span0 : span0;
            double max1 = min1 != 0.0 ? min1 + span1 : span1;
            double min = Math.max(min0, min1);
            double max = Math.min(max0, max1);
            if (MathFunctions.isSameSign((double)span0, (double)span1)) {
                if ((min1 > max0 || max1 < min0) && !AbstractEnvelope.isNegativeUnsafe(span0)) {
                    continue;
                }
            } else {
                if (Double.isNaN(span0) || Double.isNaN(span1)) continue;
                int intersect = 0;
                if (AbstractEnvelope.isNegativeUnsafe(span0)) {
                    if (min1 <= max0) {
                        min = min1;
                        intersect = 1;
                    }
                    if (max1 >= min0) {
                        max = max1;
                        intersect |= 2;
                    }
                } else {
                    if (min0 <= max1) {
                        min = min0;
                        intersect = 1;
                    }
                    if (max0 >= min1) {
                        max = max0;
                        intersect |= 2;
                    }
                }
                if (intersect == 0 || intersect == 3) {
                    double csSpan = AbstractEnvelope.getCycle(AbstractEnvelope.getAxis(this.crs, i));
                    if (span1 >= csSpan || MathFunctions.isNegativeZero((double)span1)) {
                        min = min0;
                        max = max0;
                    } else {
                        if (!(span0 >= csSpan) && !MathFunctions.isNegativeZero((double)span0)) continue;
                        min = min1;
                        max = max1;
                    }
                }
            }
            inter.setRange(i, min, max);
        }
        assert (inter.isEmpty() || this.contains(inter) && rect.contains(inter)) : inter;
        return inter;
    }

    @Override
    public Envelope2D createUnion(Rectangle2D rect) {
        Envelope2D union = this.clone();
        union.add(rect);
        assert (union.isEmpty() || union.contains(this) && union.contains(rect)) : union;
        return union;
    }

    @Override
    public void add(Rectangle2D rect) {
        Envelope2D env = rect instanceof Envelope2D ? (Envelope2D)rect : null;
        for (int i = 0; i != 2; ++i) {
            double right;
            double left;
            double span1;
            double min1;
            double span0;
            double min0;
            if (i == 0) {
                min0 = this.x;
                span0 = this.width;
                min1 = rect.getX();
                span1 = env != null ? env.width : rect.getWidth();
                this.width = Double.NaN;
                this.x = Double.NaN;
            } else {
                min0 = this.y;
                span0 = this.height;
                min1 = rect.getY();
                span1 = env != null ? env.height : rect.getHeight();
                this.height = Double.NaN;
                this.y = Double.NaN;
            }
            double max0 = min0 + span0;
            double max1 = min1 + span1;
            double min = Math.min(min0, min1);
            double max = Math.max(max0, max1);
            boolean sp0 = MathFunctions.isNegative((double)span0);
            boolean sp1 = MathFunctions.isNegative((double)span1);
            if (sp0 == sp1) {
                if (sp0 && !AbstractEnvelope.isNegativeUnsafe(max - min)) {
                    continue;
                }
            } else if (sp0) {
                if (max1 <= max0 || min1 >= min0) {
                    min = min0;
                    max = max0;
                } else {
                    left = min1 - max0;
                    right = min0 - max1;
                    if (!(left > 0.0) && !(right > 0.0)) continue;
                    if (left > right) {
                        min = min1;
                        max = max0;
                    }
                    if (right > left) {
                        min = min0;
                        max = max1;
                    }
                }
            } else if (max0 <= max1 || min0 >= min1) {
                min = min1;
                max = max1;
            } else {
                left = min0 - max1;
                right = min1 - max0;
                if (!(left > 0.0) && !(right > 0.0)) continue;
                if (left > right) {
                    min = min0;
                    max = max1;
                }
                if (right > left) {
                    min = min1;
                    max = max0;
                }
            }
            this.setRange(i, min, max);
        }
    }

    private void setRange(int dimension, double minimum, double maximum) throws IndexOutOfBoundsException {
        double span = maximum - minimum;
        switch (dimension) {
            case 0: {
                this.x = minimum;
                this.width = span;
                break;
            }
            case 1: {
                this.y = minimum;
                this.height = span;
                break;
            }
            default: {
                throw Envelope2D.indexOutOfBounds(dimension);
            }
        }
    }

    @Override
    public void add(double px, double py) {
        double r;
        double off = px - this.x;
        if (!MathFunctions.isNegative((double)this.width)) {
            if (off < 0.0) {
                this.x = px;
                this.width -= off;
            }
            if (off > this.width) {
                this.width = off;
            }
        } else if (off < 0.0 && (r = this.width - off) < 0.0) {
            if (r > off) {
                this.width = off;
            } else {
                this.x = px;
                this.width -= off;
            }
        }
        off = py - this.y;
        if (!MathFunctions.isNegative((double)this.height)) {
            if (off < 0.0) {
                this.y = py;
                this.height -= off;
            }
            if (off > this.height) {
                this.height = off;
            }
        } else if (off < 0.0 && (r = this.height - off) < 0.0) {
            if (r > off) {
                this.height = off;
            } else {
                this.y = py;
                this.height -= off;
            }
        }
        assert (this.contains(px, py) || this.isEmpty() || Double.isNaN(px) || Double.isNaN(py));
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Envelope2D) {
            Envelope2D other = (Envelope2D)object;
            return Double.doubleToLongBits(this.x) == Double.doubleToLongBits(other.x) && Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y) && Double.doubleToLongBits(this.width) == Double.doubleToLongBits(other.width) && Double.doubleToLongBits(this.height) == Double.doubleToLongBits(other.height) && Objects.equals(this.crs, other.crs);
        }
        return super.equals(object);
    }

    public boolean boundsEquals(Envelope that, int xDim, int yDim, double eps) {
        eps *= 0.5 * (this.width + this.height);
        for (int i = 0; i < 4; ++i) {
            double valueND;
            double value2D;
            int dimND;
            int dim2D = i & 1;
            int n = dimND = dim2D == 0 ? xDim : yDim;
            if ((i & 2) == 0) {
                value2D = this.getMinimum(dim2D);
                valueND = that.getMinimum(dimND);
            } else {
                value2D = this.getMaximum(dim2D);
                valueND = that.getMaximum(dimND);
            }
            if (Math.abs(value2D - valueND) <= eps) continue;
            return false;
        }
        return true;
    }

    @Override
    public Envelope2D clone() {
        return (Envelope2D)super.clone();
    }

    @Override
    public String toString() {
        return AbstractEnvelope.toString(this, false);
    }
}

