/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.pending.geoapi.referencing.MissingMethods;
import org.apache.sis.referencing.AuthorityFactories;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.EPSGFactoryFallback;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.StandardDefinitions;
import org.apache.sis.referencing.crs.DefaultEngineeringCRS;
import org.apache.sis.referencing.crs.DefaultGeocentricCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DefaultTimeCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.datum.DefaultEngineeringDatum;
import org.apache.sis.referencing.datum.DefaultTemporalDatum;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.provider.TransverseMercator;
import org.apache.sis.system.SystemListener;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public enum CommonCRS {
    WGS84(4326, 4979, 4978, 6326, 7030, 5041, 5042, 32600, 32700, 1, 60),
    WGS72(4322, 4985, 4984, 6322, 7043, 0, 0, 32200, 32300, 1, 60),
    NAD83(4269, 0, 0, 6269, 7019, 0, 0, 26900, 0, 1, 23),
    NAD27(4267, 0, 0, 6267, 7008, 0, 0, 26700, 0, 1, 22),
    ETRS89(4258, 4937, 4936, 6258, 7019, 0, 0, 25800, 0, 28, 37),
    ED50(4230, 0, 0, 6230, 7022, 0, 0, 23000, 0, 28, 38),
    GRS1980(4019, 0, 0, 6019, 7019, 0, 0, 0, 0, 0, 0),
    SPHERE(4047, 0, 0, 6047, 7048, 0, 0, 0, 0, 0, 0);

    static final CommonCRS DEFAULT;
    final short geographic;
    final short geo3D;
    final short geocentric;
    final short datum;
    final short ellipsoid;
    final short northUPS;
    final short southUPS;
    final short northUTM;
    final short southUTM;
    final byte firstZone;
    final byte lastZone;
    private transient IdentifiedObject cached;
    private volatile transient GeographicCRS cachedNormalized;
    private transient GeographicCRS cachedGeo3D;
    private transient GeocentricCRS cachedGeocentric;
    private transient GeocentricCRS cachedSpherical;
    private final Map<Integer, ProjectedCRS> cachedProjections;
    private static final int POLAR = 90;

    private CommonCRS(short geographic, short geo3D, short geocentric, short datum, short ellipsoid, short northUPS, short southUPS, short northUTM, short southUTM, byte firstZone, byte lastZone) {
        this.geographic = geographic;
        this.geocentric = geocentric;
        this.geo3D = geo3D;
        this.datum = datum;
        this.ellipsoid = ellipsoid;
        this.northUPS = northUPS;
        this.southUPS = southUPS;
        this.northUTM = northUTM;
        this.southUTM = southUTM;
        this.firstZone = firstZone;
        this.lastZone = lastZone;
        this.cachedProjections = new HashMap<Integer, ProjectedCRS>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void clear() {
        this.cached = null;
        this.cachedGeo3D = null;
        this.cachedNormalized = null;
        this.cachedGeocentric = null;
        this.cachedSpherical = null;
        Map<Integer, ProjectedCRS> map = this.cachedProjections;
        synchronized (map) {
            this.cachedProjections.clear();
        }
    }

    public static CommonCRS forDatum(CoordinateReferenceSystem crs) {
        CommonCRS c;
        SingleCRS single;
        if (crs instanceof SingleCRS) {
            single = (SingleCRS)crs;
        } else {
            single = CRS.getHorizontalComponent(crs);
            if (single == null) {
                throw new IllegalArgumentException(Errors.format((short)128, (Object)IdentifiedObjects.getDisplayName((IdentifiedObject)crs, null)));
            }
        }
        Datum datum = single.getDatum();
        if ((datum == null || datum instanceof GeodeticDatum) && (c = CommonCRS.forDatum((GeodeticDatum)datum, MissingMethods.getDatumEnsemble((CoordinateReferenceSystem)single))) != null) {
            return c;
        }
        throw new IllegalArgumentException(Errors.format((short)194, (Object)IdentifiedObjects.getDisplayName((IdentifiedObject)datum, null)));
    }

    static CommonCRS forDatum(GeodeticDatum datum, DefaultDatumEnsemble<?> ensemble) {
        String code;
        int epsg = 0;
        Identifier identifier = IdentifiedObjects.getIdentifier((IdentifiedObject)datum, (Citation)Citations.EPSG);
        if ((identifier != null || (identifier = IdentifiedObjects.getIdentifier(ensemble, (Citation)Citations.EPSG)) != null) && (code = identifier.getCode()) != null) {
            try {
                epsg = Integer.parseInt(code);
            }
            catch (NumberFormatException e) {
                Logging.recoverableException((Logger)AuthorityFactories.LOGGER, CommonCRS.class, (String)"forDatum", (Throwable)e);
            }
        }
        for (CommonCRS c : CommonCRS.values()) {
            if (!(epsg != 0 ? c.datum == epsg : DatumOrEnsemble.isLegacyDatum(c.datumEnsemble(), (Datum)datum, ComparisonMode.COMPATIBILITY) || DatumOrEnsemble.isLegacyDatum(ensemble, (Datum)c.datum(true), ComparisonMode.COMPATIBILITY))) continue;
            return c;
        }
        return null;
    }

    public static GeographicCRS defaultGeographic() {
        return DEFAULT.normalizedGeographic();
    }

    public GeographicCRS normalizedGeographic() {
        GeographicCRS crs = this.cachedNormalized;
        if (crs == null) {
            this.cachedNormalized = crs = DefaultGeographicCRS.castOrCopy(this.geographic()).forConvention(AxesConvention.RIGHT_HANDED);
        }
        return crs;
    }

    public synchronized GeographicCRS geographic() {
        GeographicCRS object = CommonCRS.geographic(this.cached);
        if (object == null) {
            GeodeticAuthorityFactory factory = CommonCRS.factory();
            if (factory != null) {
                try {
                    object = factory.createGeographicCRS(String.valueOf(this.geographic));
                    this.cached = object;
                    return object;
                }
                catch (FactoryException e) {
                    CommonCRS.failure((Object)this, "geographic", e, this.geographic);
                }
            }
            EllipsoidalCS cs = this != DEFAULT ? DEFAULT.geographic().getCoordinateSystem() : (EllipsoidalCS)StandardDefinitions.createCoordinateSystem((short)6422, true);
            object = StandardDefinitions.createGeographicCRS(this.geographic, this.datum(false), this.datumEnsemble(), cs);
            this.cached = object;
        }
        return object;
    }

    public synchronized GeographicCRS geographic3D() {
        if (this.cachedGeo3D == null) {
            GeodeticAuthorityFactory factory;
            if (this.geo3D != 0 && (factory = CommonCRS.factory()) != null) {
                try {
                    this.cachedGeo3D = factory.createGeographicCRS(String.valueOf(this.geo3D));
                    return this.cachedGeo3D;
                }
                catch (FactoryException e) {
                    CommonCRS.failure((Object)this, "geographic3D", e, this.geo3D);
                }
            }
            GeographicCRS base = this.geographic();
            EllipsoidalCS cs = this != DEFAULT ? DEFAULT.geographic3D().getCoordinateSystem() : (EllipsoidalCS)StandardDefinitions.createCoordinateSystem((short)6423, true);
            this.cachedGeo3D = new DefaultGeographicCRS(CommonCRS.properties((IdentifiedObject)base, this.geo3D), base.getDatum(), MissingMethods.getDatumEnsemble((GeodeticCRS)base), cs);
        }
        return this.cachedGeo3D;
    }

    public synchronized GeocentricCRS geocentric() {
        if (this.cachedGeocentric == null) {
            GeodeticAuthorityFactory factory;
            if (this.geocentric != 0 && (factory = CommonCRS.factory()) != null) {
                try {
                    this.cachedGeocentric = factory.createGeocentricCRS(String.valueOf(this.geocentric));
                    return this.cachedGeocentric;
                }
                catch (FactoryException e) {
                    CommonCRS.failure((Object)this, "geocentric", e, this.geocentric);
                }
            }
            GeographicCRS base = this.geographic();
            CartesianCS cs = this != DEFAULT ? (CartesianCS)DEFAULT.geocentric().getCoordinateSystem() : (CartesianCS)StandardDefinitions.createCoordinateSystem((short)6500, true);
            this.cachedGeocentric = new DefaultGeocentricCRS(CommonCRS.properties((IdentifiedObject)base, this.geocentric), base.getDatum(), MissingMethods.getDatumEnsemble((GeodeticCRS)base), cs);
        }
        return this.cachedGeocentric;
    }

    public synchronized GeocentricCRS spherical() {
        if (this.cachedSpherical == null) {
            SphericalCS cs = null;
            if (this != DEFAULT) {
                cs = (SphericalCS)DEFAULT.spherical().getCoordinateSystem();
            } else {
                GeodeticAuthorityFactory factory = CommonCRS.factory();
                if (factory != null) {
                    try {
                        cs = factory.createSphericalCS(Short.toString((short)6404));
                    }
                    catch (FactoryException e) {
                        CommonCRS.failure((Object)this, "spherical", e, 6404);
                    }
                }
                if (cs == null) {
                    cs = (SphericalCS)StandardDefinitions.createCoordinateSystem((short)6404, true);
                }
            }
            GeographicCRS base = this.geographic();
            this.cachedSpherical = new DefaultGeocentricCRS(IdentifiedObjects.getProperties((IdentifiedObject)base, CommonCRS.exclude()), base.getDatum(), MissingMethods.getDatumEnsemble((GeodeticCRS)base), cs);
        }
        return this.cachedSpherical;
    }

    @Deprecated(since="1.5", forRemoval=true)
    public GeodeticDatum datum() {
        return this.datum(true);
    }

    public synchronized GeodeticDatum datum(boolean acceptEnsemble) {
        GeodeticDatum object = CommonCRS.datumOrEnsemble(this.cached);
        if (object == null) {
            GeodeticAuthorityFactory factory = CommonCRS.factory();
            if (factory != null) {
                try {
                    object = factory.createGeodeticDatum(String.valueOf(this.datum));
                    this.cached = object;
                    return object;
                }
                catch (FactoryException e) {
                    CommonCRS.failure((Object)this, "datum", e, this.datum);
                }
            }
            Ellipsoid ei = this.ellipsoid();
            PrimeMeridian pm = this.primeMeridian();
            object = StandardDefinitions.createGeodeticDatum(this.datum, ei, pm);
            this.cached = object;
        }
        if (!acceptEnsemble && DatumOrEnsemble.asEnsemble(object).isPresent()) {
            return null;
        }
        return object;
    }

    public DefaultDatumEnsemble<GeodeticDatum> datumEnsemble() {
        return DatumOrEnsemble.asEnsemble(this.datum(true)).orElse(null);
    }

    public synchronized Ellipsoid ellipsoid() {
        Ellipsoid object = CommonCRS.ellipsoid(this.cached);
        if (object == null) {
            if (this == NAD83) {
                object = ETRS89.ellipsoid();
            } else {
                GeodeticAuthorityFactory factory = CommonCRS.factory();
                if (factory != null) {
                    try {
                        object = factory.createEllipsoid(String.valueOf(this.ellipsoid));
                        this.cached = object;
                        return object;
                    }
                    catch (FactoryException e) {
                        CommonCRS.failure((Object)this, "ellipsoid", e, this.ellipsoid);
                    }
                }
                object = StandardDefinitions.createEllipsoid(this.ellipsoid);
            }
            this.cached = object;
        }
        return object;
    }

    public synchronized PrimeMeridian primeMeridian() {
        PrimeMeridian object = CommonCRS.primeMeridian(this.cached);
        if (object == null) {
            if (this != DEFAULT) {
                object = DEFAULT.primeMeridian();
            } else {
                GeodeticAuthorityFactory factory = CommonCRS.factory();
                if (factory != null) {
                    try {
                        object = factory.createPrimeMeridian("8901");
                        this.cached = object;
                        return object;
                    }
                    catch (FactoryException e) {
                        CommonCRS.failure((Object)this, "primeMeridian", e, 8901);
                    }
                }
                object = StandardDefinitions.primeMeridian();
            }
            this.cached = object;
        }
        return object;
    }

    private static GeographicCRS geographic(IdentifiedObject object) {
        return object instanceof GeographicCRS ? (GeographicCRS)object : null;
    }

    private static GeodeticDatum datumOrEnsemble(IdentifiedObject object) {
        if (object instanceof GeodeticDatum) {
            return (GeodeticDatum)object;
        }
        if (object instanceof GeodeticCRS) {
            return DatumOrEnsemble.asDatum((GeodeticCRS)object);
        }
        return null;
    }

    private static Ellipsoid ellipsoid(IdentifiedObject object) {
        if (object instanceof Ellipsoid) {
            return (Ellipsoid)object;
        }
        if (object instanceof GeodeticDatum) {
            return ((GeodeticDatum)object).getEllipsoid();
        }
        if (object instanceof CoordinateReferenceSystem) {
            return DatumOrEnsemble.getEllipsoid((CoordinateReferenceSystem)object).orElse(null);
        }
        return null;
    }

    private static PrimeMeridian primeMeridian(IdentifiedObject object) {
        if (object instanceof PrimeMeridian) {
            return (PrimeMeridian)object;
        }
        if (object instanceof GeodeticDatum) {
            return ((GeodeticDatum)object).getPrimeMeridian();
        }
        if (object instanceof CoordinateReferenceSystem) {
            return DatumOrEnsemble.getPrimeMeridian((CoordinateReferenceSystem)object).orElse(null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectedCRS universal(double latitude, double longitude) {
        ProjectedCRS crs;
        ArgumentChecks.ensureBetween((String)"latitude", (double)-90.0, (double)90.0, (double)latitude);
        ArgumentChecks.ensureBetween((String)"longitude", (double)-4.052915431398935E8, (double)4.052915431398935E8, (double)longitude);
        boolean isSouth = MathFunctions.isNegative((double)latitude);
        boolean isUTM = latitude >= -80.0 && latitude < 84.0;
        int zone = isUTM ? TransverseMercator.Zoner.UTM.zone(latitude, longitude) : 90;
        Integer key = isSouth ? -zone : zone;
        Map<Integer, ProjectedCRS> map = this.cachedProjections;
        synchronized (map) {
            crs = this.cachedProjections.get(key);
        }
        if (crs == null) {
            ProjectedCRS other;
            int code = 0;
            if (!isUTM) {
                code = Short.toUnsignedInt(isSouth ? this.southUPS : this.northUPS);
            } else if (zone >= this.firstZone && zone <= this.lastZone) {
                code = Short.toUnsignedInt(isSouth ? this.southUTM : this.northUTM);
            }
            if (code != 0) {
                GeodeticAuthorityFactory factory;
                if (isUTM) {
                    code += zone;
                }
                if ((factory = CommonCRS.factory()) != null) {
                    try {
                        return factory.createProjectedCRS(String.valueOf(code));
                    }
                    catch (FactoryException e) {
                        CommonCRS.failure((Object)this, "universal", e, code);
                    }
                }
            }
            CartesianCS cs = null;
            if (isUTM) {
                Map<Integer, ProjectedCRS> e = CommonCRS.DEFAULT.cachedProjections;
                synchronized (e) {
                    for (Map.Entry<Integer, ProjectedCRS> entry : CommonCRS.DEFAULT.cachedProjections.entrySet()) {
                        if (Math.abs(entry.getKey()) == 90) continue;
                        cs = entry.getValue().getCoordinateSystem();
                        break;
                    }
                }
            }
            if (cs == null) {
                cs = this != DEFAULT ? DEFAULT.universal(latitude, longitude).getCoordinateSystem() : (isUTM ? StandardDefinitions.defaultCartesianCS() : (CartesianCS)StandardDefinitions.createCoordinateSystem(isSouth ? (short)1027 : 1026, true));
            }
            crs = StandardDefinitions.createUniversal(code, this.geographic(), isUTM, latitude, longitude, cs);
            Map<Integer, ProjectedCRS> map2 = this.cachedProjections;
            synchronized (map2) {
                other = this.cachedProjections.putIfAbsent(key, crs);
            }
            if (other != null) {
                return other;
            }
        }
        return crs;
    }

    private static Map<String, ?> properties(short key) {
        return CommonCRS.properties(Vocabulary.formatInternational((short)key));
    }

    private static Map<String, ?> properties(InternationalString name) {
        return Map.of("name", new NamedIdentifier(null, (CharSequence)name));
    }

    private static Map<String, ?> properties(IdentifiedObject template, short code) {
        HashMap properties = new HashMap(IdentifiedObjects.getProperties(template, CommonCRS.exclude()));
        properties.put("identifiers", new NamedIdentifier((Citation)Citations.EPSG, String.valueOf(code)));
        return properties;
    }

    private static String[] exclude() {
        return new String[]{"identifiers"};
    }

    private static GeodeticAuthorityFactory factory() {
        GeodeticAuthorityFactory factory = AuthorityFactories.getEPSG(false);
        return factory instanceof EPSGFactoryFallback ? null : factory;
    }

    private static void failure(Object caller, String method, FactoryException e, int code) {
        LogRecord record;
        String message = Resources.format((short)5, "EPSG:" + code);
        if (e instanceof UnavailableFactoryException && !AuthorityFactories.isUnavailable((UnavailableFactoryException)e)) {
            record = new LogRecord(Level.WARNING, Exceptions.formatChainedMessages(null, (String)message, (Throwable)e));
        } else {
            record = new LogRecord(Level.WARNING, message);
            record.setThrown(e);
        }
        Logging.completeAndLog((Logger)AuthorityFactories.LOGGER, caller.getClass(), (String)method, (LogRecord)record);
    }

    static {
        DEFAULT = WGS84;
        SystemListener.add((SystemListener)new SystemListener("org.apache.sis.referencing"){

            protected void classpathChanged() {
                for (CommonCRS e : CommonCRS.values()) {
                    e.clear();
                }
            }
        });
    }

    public static enum Engineering {
        GEODISPLAY(new DefaultEngineeringDatum(Map.of("name", "Computer display", "anchorPoint", "Origin is in upper left."))),
        DISPLAY(Engineering.GEODISPLAY.datum),
        GRID(new DefaultEngineeringDatum(Map.of("name", "Cell indices"))),
        TIME(new DefaultEngineeringDatum(Map.of("name", "Time")));

        private final EngineeringDatum datum;
        private EngineeringCRS crs;

        private Engineering(EngineeringDatum datum) {
            this.datum = datum;
        }

        public synchronized EngineeringCRS crs() {
            if (this.crs == null) {
                AxisDirection dy;
                String y;
                AxisDirection dx;
                String x;
                Map<String, ReferenceIdentifier> pcs = Map.of("name", this.datum.getName());
                HashMap<String, ReferenceIdentifier> properties = new HashMap<String, ReferenceIdentifier>(pcs);
                AbstractCS cs = null;
                switch (this.ordinal()) {
                    case 0: {
                        x = "i";
                        dx = AxisDirection.EAST;
                        y = "j";
                        dy = AxisDirection.SOUTH;
                        properties.put("name", new NamedIdentifier((Citation)Citations.WMS, "1"));
                        break;
                    }
                    case 1: {
                        x = "x";
                        dx = AxisDirection.DISPLAY_RIGHT;
                        y = "y";
                        dy = AxisDirection.DISPLAY_DOWN;
                        break;
                    }
                    case 2: {
                        x = "i";
                        dx = AxisDirection.COLUMN_POSITIVE;
                        y = "j";
                        dy = AxisDirection.ROW_POSITIVE;
                        break;
                    }
                    case 3: {
                        y = "t";
                        x = "t";
                        dx = dy = AxisDirection.FUTURE;
                        cs = new DefaultTimeCS((Map<String, ?>)pcs, (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Map.of("name", x), x, dx, Units.SECOND));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)this);
                    }
                }
                if (cs == null) {
                    cs = new DefaultCartesianCS((Map<String, ?>)pcs, (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Map.of("name", x), x, dx, Units.PIXEL), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Map.of("name", y), y, dy, Units.PIXEL));
                }
                this.crs = new DefaultEngineeringCRS(properties, this.datum, null, cs);
            }
            return this.crs;
        }

        public EngineeringDatum datum() {
            return this.datum;
        }

        public boolean datumUsedBy(CoordinateReferenceSystem crs) {
            for (SingleCRS component : CRS.getSingleComponents(crs)) {
                if (Utilities.equalsIgnoreMetadata((Object)this.datum, (Object)component.getDatum())) {
                    return true;
                }
                DefaultDatumEnsemble<?> ensemble = MissingMethods.getDatumEnsemble((CoordinateReferenceSystem)component);
                if (ensemble == null) continue;
                for (Datum member : ensemble.getMembers()) {
                    if (!Utilities.equalsIgnoreMetadata((Object)this.datum, (Object)member)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum Temporal {
        JULIAN(111, -210866760000L, "JulianDate", true),
        MODIFIED_JULIAN(136, -3506716800L, "ModifiedJulianDate", false),
        TRUNCATED_JULIAN(202, -50716800L, "TruncatedJulianDate", true),
        DUBLIN_JULIAN(70, -2209032000L, "DublinJulian", false),
        TROPICAL_YEAR(275, 946684800L, "TropicalYear", false),
        UNIX(196, 0L, "UnixTime", true),
        JAVA(196, 0L, "JavaTime", false);

        private final short key;
        private final long epoch;
        private final String identifier;
        private final boolean isOGC;
        private transient IdentifiedObject cached;

        private Temporal(short name, long epoch, String identifier, boolean isOGC) {
            this.key = name;
            this.epoch = epoch;
            this.identifier = identifier;
            this.isOGC = isOGC;
        }

        final synchronized void clear() {
            this.cached = null;
        }

        public static Temporal forIdentifier(String identifier, boolean onlyOGC) {
            ArgumentChecks.ensureNonEmpty((String)"identifier", (CharSequence)identifier);
            for (Temporal candidate : Temporal.values()) {
                if (!candidate.identifier.equalsIgnoreCase(identifier)) continue;
                if (onlyOGC & !candidate.isOGC) {
                    throw new IllegalArgumentException(Errors.format((short)56, (Object)"OGC", (Object)candidate.identifier));
                }
                return candidate;
            }
            throw new IllegalArgumentException(Errors.format((short)179, Temporal.class, (Object)identifier));
        }

        public static Temporal forEpoch(Instant epoch) {
            if (epoch != null && epoch.getNano() == 0) {
                long e = epoch.getEpochSecond();
                for (Temporal candidate : Temporal.values()) {
                    if (candidate.epoch != e) continue;
                    return candidate;
                }
            }
            return null;
        }

        public synchronized TemporalCRS crs() {
            TemporalCRS object = Temporal.crs(this.cached);
            if (object == null) {
                TemporalDatum datum = this.datum();
                Map<String, ?> source = this == JAVA ? CommonCRS.properties(Vocabulary.formatInternational((short)this.key, (Object)"Java")) : IdentifiedObjects.getProperties((IdentifiedObject)datum, CommonCRS.exclude());
                HashMap properties = new HashMap(source);
                properties.put("identifiers", new NamedIdentifier((Citation)(this.isOGC ? Citations.OGC : Citations.SIS), this.identifier));
                object = new DefaultTemporalCRS(properties, datum, null, this.cs());
                this.cached = object;
            }
            return object;
        }

        private TimeCS cs() {
            Map<String, ?> axis;
            Unit unit;
            switch (this.ordinal()) {
                default: {
                    return TRUNCATED_JULIAN.crs().getCoordinateSystem();
                }
                case 2: {
                    unit = Units.DAY;
                    break;
                }
                case 4: {
                    unit = Units.TROPICAL_YEAR;
                    break;
                }
                case 5: {
                    unit = Units.SECOND;
                    break;
                }
                case 6: {
                    unit = Units.MILLISECOND;
                }
            }
            if (this == TRUNCATED_JULIAN) {
                axis = CommonCRS.properties((short)195);
            } else {
                TimeCS share = TRUNCATED_JULIAN.crs().getCoordinateSystem();
                axis = IdentifiedObjects.getProperties((IdentifiedObject)share.getAxis(0), CommonCRS.exclude());
            }
            Map<String, ?> cs = CommonCRS.properties(Vocabulary.formatInternational((short)276, (Object)unit));
            return new DefaultTimeCS(cs, (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(axis, "t", AxisDirection.FUTURE, unit));
        }

        public synchronized TemporalDatum datum() {
            TemporalDatum object = Temporal.datum(this.cached);
            if (object == null) {
                if (this == UNIX) {
                    object = JAVA.datum();
                    this.cached = object;
                    return object;
                }
                Map<String, ?> properties = this.key == 196 ? CommonCRS.properties(Vocabulary.formatInternational((short)this.key, (Object)"Unix/POSIX")) : CommonCRS.properties(this.key);
                object = new DefaultTemporalDatum(properties, Instant.ofEpochSecond(this.epoch));
                this.cached = object;
            }
            return object;
        }

        private static TemporalCRS crs(IdentifiedObject object) {
            return object instanceof TemporalCRS ? (TemporalCRS)object : null;
        }

        private static TemporalDatum datum(IdentifiedObject object) {
            if (object instanceof TemporalDatum) {
                return (TemporalDatum)object;
            }
            if (object instanceof TemporalCRS) {
                return ((TemporalCRS)object).getDatum();
            }
            return null;
        }

        static {
            SystemListener.add((SystemListener)new SystemListener("org.apache.sis.referencing"){

                protected void classpathChanged() {
                    for (Temporal e : Temporal.values()) {
                        e.clear();
                    }
                }
            });
        }
    }

    public static enum Vertical {
        BAROMETRIC(false, 16, 32),
        MEAN_SEA_LEVEL(true, 5714, 5100),
        DEPTH(true, 5715, 5100),
        NAVD88(true, 5703, 5103),
        ELLIPSOIDAL(false, 74, 72),
        OTHER_SURFACE(false, 98, 156);

        final boolean isEPSG;
        final short crs;
        final short datum;
        private transient IdentifiedObject cached;

        private Vertical(boolean isEPSG, short crs, short datum) {
            this.isEPSG = isEPSG;
            this.crs = crs;
            this.datum = datum;
        }

        final synchronized void clear() {
            this.cached = null;
        }

        public synchronized VerticalCRS crs() {
            VerticalCRS object = Vertical.crs(this.cached);
            if (object == null) {
                GeodeticAuthorityFactory factory;
                if (this.isEPSG && (factory = CommonCRS.factory()) != null) {
                    try {
                        object = factory.createVerticalCRS(String.valueOf(this.crs));
                        this.cached = object;
                        return object;
                    }
                    catch (FactoryException e) {
                        CommonCRS.failure((Object)this, "crs", e, this.crs);
                    }
                }
                if (this.isEPSG) {
                    object = StandardDefinitions.createVerticalCRS(this.crs, this.datum());
                } else {
                    VerticalCS cs = this.cs();
                    object = new DefaultVerticalCRS(IdentifiedObjects.getProperties((IdentifiedObject)cs, CommonCRS.exclude()), this.datum(), null, cs);
                }
                this.cached = object;
            }
            return object;
        }

        private VerticalCS cs() {
            Unit unit;
            Map<String, ?> properties = CommonCRS.properties(this.crs);
            switch (this.ordinal()) {
                default: {
                    unit = Units.METRE;
                    break;
                }
                case 0: {
                    unit = Units.HECTOPASCAL;
                }
            }
            return new DefaultVerticalCS(properties, (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(properties, "h", AxisDirection.UP, unit));
        }

        public synchronized VerticalDatum datum() {
            Object object = Vertical.datum(this.cached);
            if (object == null) {
                GeodeticAuthorityFactory factory;
                if (this.isEPSG && (factory = CommonCRS.factory()) != null) {
                    try {
                        object = factory.createVerticalDatum(String.valueOf(this.datum));
                        this.cached = object;
                        return object;
                    }
                    catch (FactoryException e) {
                        CommonCRS.failure((Object)this, "datum", e, this.datum);
                    }
                }
                object = this.isEPSG ? StandardDefinitions.createVerticalDatum(this.datum) : new DefaultVerticalDatum(CommonCRS.properties(this.datum), VerticalDatumType.valueOf((String)this.name()));
                this.cached = object;
            }
            return object;
        }

        private static VerticalCRS crs(IdentifiedObject object) {
            return object instanceof VerticalCRS ? (VerticalCRS)object : null;
        }

        private static VerticalDatum datum(IdentifiedObject object) {
            if (object instanceof VerticalDatum) {
                return (VerticalDatum)object;
            }
            if (object instanceof VerticalCRS) {
                return ((VerticalCRS)object).getDatum();
            }
            return null;
        }

        static {
            SystemListener.add((SystemListener)new SystemListener("org.apache.sis.referencing"){

                protected void classpathChanged() {
                    for (Vertical e : Vertical.values()) {
                        e.clear();
                    }
                }
            });
        }
    }
}

