/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.PolarCS;

@XmlType(name="PolarCSType")
@XmlRootElement(name="PolarCS")
public class DefaultPolarCS
extends AbstractCS
implements PolarCS {
    private static final long serialVersionUID = 3960197260975470951L;

    public DefaultPolarCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) {
        super(properties, axis0, axis1);
    }

    private DefaultPolarCS(DefaultPolarCS original, String name, CoordinateSystemAxis[] axes) {
        super(original, name, axes);
    }

    protected DefaultPolarCS(PolarCS original) {
        super((CoordinateSystem)original);
    }

    public static DefaultPolarCS castOrCopy(PolarCS object) {
        return object == null || object instanceof DefaultPolarCS ? (DefaultPolarCS)object : new DefaultPolarCS(object);
    }

    @Override
    final int validateAxis(AxisDirection direction, Unit<?> unit) {
        if (!AxisDirections.isSpatialOrUserDefined(direction, false)) {
            return 1;
        }
        if (!Units.isLinear(unit) && !Units.isAngular(unit)) {
            return 2;
        }
        return 0;
    }

    public Class<? extends PolarCS> getInterface() {
        return PolarCS.class;
    }

    @Override
    public DefaultPolarCS forConvention(AxesConvention convention) {
        return (DefaultPolarCS)super.forConvention(convention);
    }

    @Override
    final AbstractCS createForAxes(String name, CoordinateSystemAxis[] axes) {
        switch (axes.length) {
            case 2: {
                return new DefaultPolarCS(this, name, axes);
            }
        }
        throw DefaultPolarCS.unexpectedDimension(axes, 2, 2);
    }

    private DefaultPolarCS() {
    }
}

