/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.GeocentricAffineBetweenGeographic;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.referencing.operation.transform.WraparoundTransform;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Wraparound
extends AbstractProvider {
    private static final long serialVersionUID = -7464255385789611569L;
    public static final ParameterDescriptor<Integer> DIMENSION;
    public static final ParameterDescriptor<Integer> WRAPAROUND_DIMENSION;
    public static final ParameterDescriptor<Double> PERIOD;
    public static final ParameterDescriptorGroup PARAMETERS;

    public Wraparound() {
        super(Conversion.class, PARAMETERS, CoordinateSystem.class, false, CoordinateSystem.class, false, (byte)1);
    }

    @Override
    public MathTransform createMathTransform(MathTransformProvider.Context context) throws FactoryException {
        Parameters pg = Parameters.castOrWrap(context.getCompletedParameters());
        return WraparoundTransform.create(pg.intValue(DIMENSION), pg.intValue(WRAPAROUND_DIMENSION), pg.doubleValue(PERIOD), Double.NaN, 0.0);
    }

    static {
        ParameterBuilder builder = (ParameterBuilder)Wraparound.builder().setCodeSpace(Citations.SIS, "SIS");
        DIMENSION = ((ParameterBuilder)builder.addName(GeocentricAffineBetweenGeographic.DIMENSION.getName())).createBounded(Integer.class, Integer.valueOf(1), null, null);
        WRAPAROUND_DIMENSION = ((ParameterBuilder)builder.addName("wraparound_dim")).createBounded(Integer.class, Integer.valueOf(0), null, null);
        PERIOD = ((ParameterBuilder)builder.addName("period")).createStrictlyPositive(Double.NaN, null);
        PARAMETERS = ((ParameterBuilder)builder.addName("Wraparound")).createGroup(new GeneralParameterDescriptor[]{DIMENSION, WRAPAROUND_DIMENSION, PERIOD});
    }
}

