/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Point;
import java.awt.image.ImagingOpException;
import java.awt.image.TileObserver;
import java.awt.image.WritableRenderedImage;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.image.ComputedImage;
import org.apache.sis.image.TileCache;
import org.apache.sis.system.ReferenceQueueConsumer;
import org.apache.sis.util.Disposable;

final class ComputedTiles
extends WeakReference<ComputedImage>
implements Disposable,
TileObserver {
    private static final int VALID = 0;
    private static final int DIRTY = -1;
    private static final int ERROR = -2;
    private static final int COMPUTING = 1;
    private final Map<TileCache.Key, Integer> cachedTiles = new HashMap<TileCache.Key, Integer>();
    private WritableRenderedImage[] sources;

    ComputedTiles(ComputedImage image, WritableRenderedImage[] ws) {
        super(image, ReferenceQueueConsumer.QUEUE);
        this.sources = ws;
        if (ws != null) {
            int i = 0;
            try {
                while (i < ws.length) {
                    WritableRenderedImage source = ws[i++];
                    source.addTileObserver(this);
                }
            }
            catch (RuntimeException e) {
                this.unregister(ws, i, e);
            }
        }
    }

    private static boolean isWritable(Integer value) {
        if (value == null) {
            return false;
        }
        int n = value;
        return n >= 1 || n < -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isTileWritable(TileCache.Key key) {
        Integer value;
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            value = this.cachedTiles.get(key);
        }
        return ComputedTiles.isWritable(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isTileDirty(TileCache.Key key) {
        Integer value;
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            value = this.cachedTiles.get(key);
        }
        if (value != null) {
            switch (value) {
                case -1: {
                    break;
                }
                case -2: {
                    throw new ImagingOpException(key.error((short)60));
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean trySetComputing(TileCache.Key key) {
        Integer value;
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            value = this.cachedTiles.putIfAbsent(key, 1);
            if (value == null || this.cachedTiles.replace(key, -1, 1)) {
                return true;
            }
        }
        if (value == -2) {
            throw new ImagingOpException(key.error((short)60));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean startWrite(TileCache.Key key) {
        Integer value = 1;
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            value = this.cachedTiles.merge(key, value, ComputedTiles::increment);
        }
        return value == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean endWrite(TileCache.Key key, boolean success) {
        int status = success ? 0 : -2;
        Integer value = status;
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            value = this.cachedTiles.merge(key, value, ComputedTiles::decrement);
        }
        return value == status;
    }

    private static Integer increment(Integer value, Integer computing) {
        int n = value;
        switch (n) {
            case -2: 
            case -1: 
            case 0: {
                return computing;
            }
            case -3: {
                throw new ArithmeticException();
            }
        }
        return n + 1;
    }

    private static Integer decrement(Integer value, Integer status) {
        int n = value;
        if (n >= -2 && n <= 1) {
            return status;
        }
        return n - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean getWritableTileIndices(List<Point> indices) {
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            for (Map.Entry<TileCache.Key, Integer> entry : this.cachedTiles.entrySet()) {
                if (!ComputedTiles.isWritable(entry.getValue())) continue;
                if (indices == null) {
                    return true;
                }
                indices.add(entry.getKey().indices());
            }
        }
        return indices != null && !indices.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean markDirtyTiles(int minTileX, int minTileY, int maxTileX, int maxTileY, boolean error) {
        Integer search = error ? -2 : 0;
        Integer dirty = -1;
        boolean updated = false;
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            for (int tileY = minTileY; tileY <= maxTileY; ++tileY) {
                for (int tileX = minTileX; tileX <= maxTileX; ++tileX) {
                    TileCache.Key key = new TileCache.Key(this, tileX, tileY);
                    updated |= this.cachedTiles.replace(key, search, dirty);
                }
            }
        }
        return updated;
    }

    @Override
    public void tileUpdate(WritableRenderedImage source, int tileX, int tileY, boolean willBeWritable) {
        if (!willBeWritable) {
            ComputedImage target = (ComputedImage)this.get();
            if (target != null) {
                target.sourceTileChanged(source, tileX, tileY);
            } else {
                source.removeTileObserver(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            this.cachedTiles.keySet().forEach(TileCache.Key::dispose);
            this.cachedTiles.clear();
        }
        WritableRenderedImage[] ws = this.sources;
        if (ws != null) {
            this.unregister(ws, ws.length, null);
        }
    }

    private void unregister(WritableRenderedImage[] ws, int i, RuntimeException failure) {
        this.sources = null;
        while (--i >= 0) {
            try {
                ws[i].removeTileObserver(this);
            }
            catch (RuntimeException e) {
                if (failure == null) {
                    failure = e;
                    continue;
                }
                failure.addSuppressed(e);
            }
        }
        if (failure != null) {
            throw failure;
        }
    }
}

