/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.Console;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Locale;
import java.util.logging.LogManager;
import org.apache.sis.console.AboutCommand;
import org.apache.sis.console.CRSCommand;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.console.HelpCommand;
import org.apache.sis.console.IdentifierCommand;
import org.apache.sis.console.InfoCommand;
import org.apache.sis.console.InvalidCommandException;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.MetadataCommand;
import org.apache.sis.console.MimeTypeCommand;
import org.apache.sis.console.Option;
import org.apache.sis.console.TransformCommand;
import org.apache.sis.console.TranslateCommand;
import org.apache.sis.system.Environment;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.X364;
import org.apache.sis.util.logging.Initializer;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.MonolineFormatter;
import org.apache.sis.util.resources.Errors;

public final class Command {
    public static final int INVALID_COMMAND_EXIT_CODE = 1;
    public static final int INVALID_OPTION_EXIT_CODE = 2;
    public static final int INVALID_ARGUMENT_EXIT_CODE = 3;
    public static final int UNKNOWN_STORAGE_EXIT_CODE = 4;
    public static final int IO_EXCEPTION_EXIT_CODE = 100;
    public static final int SQL_EXCEPTION_EXIT_CODE = 101;
    public static final int OTHER_ERROR_EXIT_CODE = 199;
    private final CommandRunner command;

    public Command(Object[] args) throws InvalidCommandException, InvalidOptionException {
        int commandIndex = -1;
        String commandName = null;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof CharSequence)) continue;
            String s = arg.toString();
            if (s.startsWith("--")) {
                String name = s.substring("--".length());
                Option option = Option.forLabel(name);
                if (!option.hasValue) continue;
                ++i;
                continue;
            }
            commandName = s;
            commandIndex = i;
            break;
        }
        if (commandName == null) {
            this.command = new HelpCommand(-1, args);
        } else {
            switch (commandName.toLowerCase(Locale.US)) {
                case "help": {
                    this.command = new HelpCommand(commandIndex, args);
                    break;
                }
                case "about": {
                    this.command = new AboutCommand(commandIndex, args);
                    break;
                }
                case "mime-type": {
                    this.command = new MimeTypeCommand(commandIndex, args);
                    break;
                }
                case "metadata": {
                    this.command = new MetadataCommand(commandIndex, args);
                    break;
                }
                case "crs": {
                    this.command = new CRSCommand(commandIndex, args);
                    break;
                }
                case "info": {
                    this.command = new InfoCommand(commandIndex, args);
                    break;
                }
                case "identifier": {
                    this.command = new IdentifierCommand(commandIndex, args);
                    break;
                }
                case "transform": {
                    this.command = new TransformCommand(commandIndex, args);
                    break;
                }
                case "translate": {
                    this.command = new TranslateCommand(commandIndex, args);
                    break;
                }
                default: {
                    throw new InvalidCommandException(Errors.format((short)178, (Object)commandName), commandName);
                }
            }
        }
    }

    public static void configureLogging() {
        String value = System.getenv("SIS_HOME");
        if (value != null) {
            Path home = Path.of(value, new String[0]).normalize();
            Path file = home.resolve("log");
            if (Files.isDirectory(file, new LinkOption[0])) {
                Command.setPropertyIfAbsent("derby.stream.error.file", file.resolve("derby.log"));
            }
            if (Files.isRegularFile(file = home.resolve("conf").resolve("logging.properties"), new LinkOption[0]) && Command.setPropertyIfAbsent("java.util.logging.config.file", file)) {
                try {
                    Initializer.reload((Path)file);
                }
                catch (IOException e) {
                    Logging.unexpectedException(null, Command.class, (String)"configureLogging", (Throwable)e);
                }
            }
        }
        String handler = LogManager.getLogManager().getProperty("java.util.logging.ConsoleHandler.formatter");
        if (MonolineFormatter.class.getName().equals(handler)) {
            MonolineFormatter f = MonolineFormatter.install();
            f.setMaximalLineLength(Command::terminalSize);
            f.resetLevelColors(X364.isAnsiSupported());
        }
    }

    private static int terminalSize() {
        String n = System.getenv("COLUMNS");
        if (n != null && !n.isEmpty()) {
            try {
                return Integer.parseInt(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Integer.MAX_VALUE;
    }

    private static boolean setPropertyIfAbsent(String property, Path value) {
        if (System.getProperty(property) == null) {
            System.setProperty(property, value.toString());
            return true;
        }
        return false;
    }

    public PrintWriter writer(boolean error) {
        return error ? this.command.err : this.command.out;
    }

    final void setFaintOutput(boolean faint) {
        this.command.color(faint ? X364.FAINT : X364.NORMAL);
    }

    public int run() throws Exception {
        if (this.command.hasContradictoryOptions(Option.BRIEF, Option.VERBOSE)) {
            return 2;
        }
        if (!this.command.options.containsKey((Object)Option.HELP)) {
            try {
                CommandRunner.instance.set(this.command);
                int status = this.command.run();
                this.command.flush();
                int n = status;
                return n;
            }
            catch (Exception e) {
                this.command.error(null, e);
                throw e;
            }
            finally {
                CommandRunner.instance.remove();
            }
        }
        this.command.help(this.command.commandName.toLowerCase(Locale.US));
        return 0;
    }

    public static int exitCodeFor(Throwable cause) {
        while (cause != null) {
            if (cause instanceof InvalidCommandException) {
                return 1;
            }
            if (cause instanceof InvalidOptionException) {
                return 2;
            }
            if (cause instanceof IOException) {
                return 100;
            }
            if (cause instanceof SQLException) {
                return 101;
            }
            cause = cause.getCause();
        }
        return 199;
    }

    private static void error(String[] args, Exception e) {
        boolean debug = ArraysExt.containsIgnoreCase((String[])args, (String)"--debug");
        PrintWriter err = Environment.writer((Console)System.console(), (PrintStream)System.err);
        if (debug) {
            e.printStackTrace(err);
        } else {
            err.println(e.getLocalizedMessage());
        }
        err.flush();
    }

    public static void main(String[] args) {
        int status;
        Command c;
        Command.configureLogging();
        try {
            c = new Command(args);
        }
        catch (InvalidCommandException e) {
            Command.error(args, e);
            System.exit(1);
            return;
        }
        catch (InvalidOptionException e) {
            Command.error(args, e);
            System.exit(2);
            return;
        }
        try {
            status = c.run();
        }
        catch (Exception e) {
            status = Command.exitCodeFor(e);
        }
        if (status != 0) {
            System.exit(status);
        }
    }
}

