/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.tiling;

import java.util.Optional;
import java.util.SortedMap;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.tiling.TileMatrix;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;

public interface TileMatrixSet {
    public GenericName getIdentifier();

    default public Metadata getMetadata() {
        MetadataBuilder mb = new MetadataBuilder();
        mb.addIdentifier(this.getIdentifier(), MetadataBuilder.Scope.RESOURCE);
        this.getEnvelope().ifPresent(envelope -> mb.addExtent((Envelope)envelope, null));
        mb.addReferenceSystem((ReferenceSystem)this.getCoordinateReferenceSystem());
        return mb.build();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem();

    public Optional<Envelope> getEnvelope();

    public SortedMap<GenericName, ? extends TileMatrix> getTileMatrices();
}

