/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.stream;

import java.util.Comparator;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.apache.sis.util.stream.PaginedDoubleStream;
import org.apache.sis.util.stream.StreamWrapper;

public final class PaginedStream<T>
extends StreamWrapper<T> {
    private Stream<?> root;

    public PaginedStream(Stream<T> source, Stream<?> root) {
        super(source);
        this.root = root;
    }

    @Override
    public Stream<T> skip(long n) {
        this.root = this.root.skip(n);
        return this;
    }

    @Override
    public Stream<T> limit(long maxSize) {
        this.root = this.root.limit(maxSize);
        return this;
    }

    @Override
    public long count() {
        return this.root.count();
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return new PaginedDoubleStream(super.mapToDouble(mapper), this.root);
    }

    @Override
    public Stream<T> distinct() {
        return this.delegate().distinct();
    }

    @Override
    public Stream<T> unordered() {
        return (Stream)this.delegate().unordered();
    }

    @Override
    public Stream<T> sorted() {
        return this.delegate().sorted();
    }

    @Override
    public Stream<T> sorted(Comparator<? super T> comparator) {
        return this.delegate().sorted(comparator);
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        return this.delegate().filter(predicate);
    }
}

