/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.base;

import java.util.Optional;
import java.util.function.Consumer;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.base.Node;
import org.apache.sis.util.Classes;
import org.opengis.util.ScopedName;

public final class WarningEvent {
    public static final ThreadLocal<Consumer<WarningEvent>> LISTENER = new ThreadLocal();
    private final Object source;
    public final Exception exception;
    public final boolean recoverable;

    public WarningEvent(Object source, Exception exception, boolean recoverable) {
        this.source = source;
        this.exception = exception;
        this.recoverable = recoverable;
    }

    public Optional<Enum<?>> getOperatorType() {
        if (this.source instanceof Filter) {
            return Optional.of(((Filter)this.source).getOperatorType());
        }
        return Optional.empty();
    }

    public Optional<ScopedName> getFunctionName() {
        if (this.source instanceof Expression) {
            return Optional.of(((Expression)this.source).getFunctionName());
        }
        return Optional.empty();
    }

    public <P extends Expression<?, ?>> Optional<P> getParameter(Class<P> type) {
        if (this.source instanceof Filter) {
            for (Expression parameter : ((Filter)this.source).getExpressions()) {
                if (!type.isInstance(parameter)) continue;
                return Optional.of(parameter);
            }
        }
        if (this.source instanceof Expression) {
            for (Expression parameter : ((Expression)this.source).getParameters()) {
                if (!type.isInstance(parameter)) continue;
                return Optional.of(parameter);
            }
        }
        return Optional.empty();
    }

    public String toString() {
        return String.valueOf(this.source instanceof Node ? ((Node)this.source).getDisplayName() : Classes.getShortClassName((Object)this.source)) + ": " + String.valueOf(this.exception);
    }
}

