/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Map;
import javax.inject.Inject;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.RequestAttributeInjector;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.testutil.ModelAdapterFactoryUtil;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.apache.sling.testing.mock.osgi.junit5.OsgiContext;
import org.apache.sling.testing.mock.osgi.junit5.OsgiContextExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={OsgiContextExtension.class, MockitoExtension.class})
class ModelAdapterFactory_InjectorOrderTest {
    final OsgiContext context = new OsgiContext();
    @Mock
    private AdapterManager adapterManager;
    @Mock
    private BindingsValuesProvidersByContext bindingsValuesProvidersByContext;
    @Mock
    private SlingJakartaHttpServletRequest request;
    @Mock
    private Resource resource;
    private ModelAdapterFactory factory;

    ModelAdapterFactory_InjectorOrderTest() {
    }

    @BeforeEach
    void setUp() {
        this.context.registerService(BindingsValuesProvidersByContext.class, (Object)this.bindingsValuesProvidersByContext);
        this.context.registerService(AdapterManager.class, (Object)this.adapterManager);
        this.factory = (ModelAdapterFactory)this.context.registerInjectActivateService(ModelAdapterFactory.class);
        ModelAdapterFactoryUtil.addModelsForPackage(this.context.bundleContext(), TestModel.class);
        Mockito.lenient().when((Object)this.request.getResource()).thenReturn((Object)this.resource);
        Mockito.lenient().when((Object)((ValueMap)this.resource.adaptTo(ValueMap.class))).thenReturn((Object)new ValueMapDecorator(Map.of("prop1", 1)));
        Mockito.lenient().when(this.request.getAttribute("prop1")).thenReturn((Object)2);
    }

    @Test
    void testSingleInjector_ValueMap() {
        this.context.registerService(Injector.class, (Object)new ValueMapInjector(), new Object[]{"service.ranking", 2000});
        TestModel model = (TestModel)this.factory.createModel((Object)this.request, TestModel.class);
        Assertions.assertEquals((Integer)1, (Integer)model.getProp1());
    }

    @Test
    void testSingleInjector_RequestAttribute() {
        this.context.registerService(Injector.class, (Object)new RequestAttributeInjector(), new Object[]{"service.ranking", 4000});
        TestModel model = (TestModel)this.factory.createModel((Object)this.request, TestModel.class);
        Assertions.assertEquals((Integer)2, (Integer)model.getProp1());
    }

    @Test
    void testMultipleInjectors() {
        this.context.registerService(Injector.class, (Object)new RequestAttributeInjector(), new Object[]{"service.ranking", 4000});
        this.context.registerService(Injector.class, (Object)new ValueMapInjector(), new Object[]{"service.ranking", 2000});
        TestModel model = (TestModel)this.factory.createModel((Object)this.request, TestModel.class);
        Assertions.assertEquals((Integer)1, (Integer)model.getProp1());
    }

    @Model(adaptables={SlingJakartaHttpServletRequest.class})
    private static interface TestModel {
        @Inject
        public Integer getProp1();
    }
}

