/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.configurator;

import jakarta.annotation.Priority;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.ObservesAsync;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.EventContext;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.enterprise.inject.spi.configurator.ObserverMethodConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.event.EventContextImpl;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.exception.WebBeansException;

public class ObserverMethodConfiguratorImpl<T>
implements ObserverMethodConfigurator<T> {
    private final WebBeansContext webBeansContext;
    private ObserverMethod<T> originalObserverMethod;
    private final Extension extension;
    private Class<?> beanClass;
    private Set<Annotation> qualifiers = new HashSet<Annotation>();
    private Type observedType;
    private Reception reception = Reception.ALWAYS;
    private TransactionPhase transactionPhase = TransactionPhase.IN_PROGRESS;
    private int priority = 2500;
    private boolean async;
    private ObserverMethodConfigurator.EventConsumer notifyWith;

    public ObserverMethodConfiguratorImpl(WebBeansContext webBeansContext, Extension extension, ObserverMethod<T> observerMethod) {
        this(webBeansContext, extension);
        this.read(observerMethod);
        this.originalObserverMethod = observerMethod;
    }

    public ObserverMethodConfiguratorImpl(WebBeansContext webBeansContext, Extension extension) {
        this.webBeansContext = webBeansContext;
        this.extension = extension;
    }

    public ObserverMethodConfigurator<T> read(Method method) {
        this.qualifiers = this.getQualifiers(Arrays.asList(method.getAnnotations()));
        this.beanClass = method.getDeclaringClass();
        for (Parameter parameter : method.getParameters()) {
            Observes observes = parameter.getAnnotation(Observes.class);
            ObservesAsync observesAsync = parameter.getAnnotation(ObservesAsync.class);
            if (observes == null && observesAsync == null) continue;
            this.observedType = parameter.getParameterizedType();
            if (observes != null) {
                this.reception = observes.notifyObserver();
                this.transactionPhase = observes.during();
            } else {
                this.reception = observesAsync.notifyObserver();
                this.transactionPhase = TransactionPhase.IN_PROGRESS;
                this.async = true;
            }
            Priority prio = parameter.getAnnotation(Priority.class);
            if (prio == null) break;
            this.priority = prio.value();
            break;
        }
        return this;
    }

    public ObserverMethodConfigurator<T> read(AnnotatedMethod annotatedMethod) {
        this.qualifiers = this.getQualifiers(annotatedMethod.getAnnotations());
        this.beanClass = annotatedMethod.getDeclaringType().getJavaClass();
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            Observes observes = (Observes)parameter.getAnnotation(Observes.class);
            ObservesAsync observesAsync = (ObservesAsync)parameter.getAnnotation(ObservesAsync.class);
            if (observes == null && observesAsync == null) continue;
            this.observedType = parameter.getBaseType();
            if (observes != null) {
                this.reception = observes.notifyObserver();
                this.transactionPhase = observes.during();
            } else {
                this.reception = observesAsync.notifyObserver();
                this.transactionPhase = TransactionPhase.IN_PROGRESS;
                this.async = true;
            }
            Priority prio = (Priority)parameter.getAnnotation(Priority.class);
            if (prio == null) break;
            this.priority = prio.value();
            break;
        }
        return this;
    }

    private Set<Annotation> getQualifiers(Collection<Annotation> annotations) {
        BeanManagerImpl bm = this.webBeansContext.getBeanManagerImpl();
        return annotations.stream().filter(a -> bm.isQualifier(a.annotationType())).collect(Collectors.toSet());
    }

    public ObserverMethodConfigurator<T> read(ObserverMethod observerMethod) {
        this.beanClass = observerMethod.getBeanClass();
        this.qualifiers.addAll(observerMethod.getObservedQualifiers());
        this.observedType = observerMethod.getObservedType();
        this.reception = observerMethod.getReception();
        this.transactionPhase = observerMethod.getTransactionPhase();
        this.priority = observerMethod.getPriority();
        this.async = observerMethod.isAsync();
        return this;
    }

    public ObserverMethodConfigurator<T> beanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    public ObserverMethodConfigurator<T> observedType(Type type) {
        this.observedType = type;
        return this;
    }

    public ObserverMethodConfigurator<T> addQualifier(Annotation qualifier) {
        this.qualifiers.add(qualifier);
        return this;
    }

    public ObserverMethodConfigurator<T> addQualifiers(Annotation ... qualifiers) {
        for (Annotation qualifier : qualifiers) {
            this.qualifiers.add(qualifier);
        }
        return this;
    }

    public ObserverMethodConfigurator<T> addQualifiers(Set qualifiers) {
        this.qualifiers.addAll(qualifiers);
        return this;
    }

    public ObserverMethodConfigurator<T> qualifiers(Annotation ... qualifiers) {
        this.qualifiers.clear();
        this.addQualifiers(qualifiers);
        return this;
    }

    public ObserverMethodConfigurator<T> qualifiers(Set qualifiers) {
        this.qualifiers.clear();
        this.addQualifiers(qualifiers);
        return this;
    }

    public ObserverMethodConfigurator<T> reception(Reception reception) {
        this.reception = reception;
        return this;
    }

    public ObserverMethodConfigurator<T> transactionPhase(TransactionPhase transactionPhase) {
        this.transactionPhase = transactionPhase;
        return this;
    }

    public ObserverMethodConfigurator<T> priority(int priority) {
        this.priority = priority;
        return this;
    }

    public ObserverMethodConfigurator<T> notifyWith(ObserverMethodConfigurator.EventConsumer callback) {
        this.notifyWith = callback;
        return this;
    }

    public ObserverMethodConfigurator<T> async(boolean async) {
        this.async = async;
        return this;
    }

    public <T> ObserverMethod<T> getObserverMethod() {
        if (this.observedType == null) {
            String extensionName = this.extension != null ? "(" + this.extension.toString() + ") ! " : "! ";
            WebBeansDeploymentException e = new WebBeansDeploymentException("ObserverMethod observedType is missing " + extensionName + this.toString());
            this.webBeansContext.getBeanManagerImpl().getErrorStack().pushError((Throwable)((Object)e));
            return null;
        }
        if (this.originalObserverMethod == null && this.notifyWith == null) {
            String extensionName = this.extension != null ? "(" + this.extension.toString() + ") ! " : "! ";
            WebBeansDeploymentException e = new WebBeansDeploymentException("ObserverMethod notifyWith is missing " + extensionName + this.toString());
            this.webBeansContext.getBeanManagerImpl().getErrorStack().pushError((Throwable)((Object)e));
            return null;
        }
        return new ConfiguredObserverMethod();
    }

    public Extension getExtension() {
        return this.extension;
    }

    public String toString() {
        return "ObserverMethodConfiguratorImpl{beanClass=" + this.beanClass + ", qualifiers=" + this.qualifiers + ", observedType=" + this.observedType + ", reception=" + this.reception + ", transactionPhase=" + this.transactionPhase + ", priority=" + this.priority + ", async=" + this.async + ", notifyWith=" + this.notifyWith + "}";
    }

    public class ConfiguredObserverMethod<T>
    implements ObserverMethod<T> {
        public Class<?> getBeanClass() {
            return ObserverMethodConfiguratorImpl.this.beanClass != null ? ObserverMethodConfiguratorImpl.this.beanClass : ObserverMethodConfiguratorImpl.this.extension.getClass();
        }

        public Type getObservedType() {
            return ObserverMethodConfiguratorImpl.this.observedType;
        }

        public Set<Annotation> getObservedQualifiers() {
            return ObserverMethodConfiguratorImpl.this.qualifiers;
        }

        public Reception getReception() {
            return ObserverMethodConfiguratorImpl.this.reception;
        }

        public TransactionPhase getTransactionPhase() {
            return ObserverMethodConfiguratorImpl.this.transactionPhase;
        }

        public void notify(T event) {
            this.notify(new EventContextImpl<T>(event, null));
        }

        public void notify(EventContext<T> eventContext) {
            try {
                if (ObserverMethodConfiguratorImpl.this.notifyWith == null && ObserverMethodConfiguratorImpl.this.originalObserverMethod != null) {
                    ObserverMethodConfiguratorImpl.this.originalObserverMethod.notify(eventContext);
                } else {
                    ObserverMethodConfiguratorImpl.this.notifyWith.accept(eventContext);
                }
            }
            catch (Exception e) {
                throw new WebBeansException(e);
            }
        }

        public boolean isAsync() {
            return ObserverMethodConfiguratorImpl.this.async;
        }

        public int getPriority() {
            return ObserverMethodConfiguratorImpl.this.priority;
        }
    }
}

