/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.SignatureSigningParametersResolver;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.criterion.KeyInfoGenerationProfileCriterion;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.impl.AbstractSecurityParametersResolver;
import org.opensaml.xmlsec.impl.AlgorithmRuntimeSupportedPredicate;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.slf4j.Logger;

public class BasicSignatureSigningParametersResolver
extends AbstractSecurityParametersResolver<SignatureSigningParameters>
implements SignatureSigningParametersResolver {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(BasicSignatureSigningParametersResolver.class);
    @Nullable
    private AlgorithmRegistry algorithmRegistry = AlgorithmSupport.getGlobalAlgorithmRegistry();

    @Nonnull
    public AlgorithmRegistry getAlgorithmRegistry() {
        if (this.algorithmRegistry == null) {
            return AlgorithmSupport.ensureGlobalAlgorithmRegistry();
        }
        assert (this.algorithmRegistry != null);
        return this.algorithmRegistry;
    }

    public void setAlgorithmRegistry(@Nonnull AlgorithmRegistry registry) {
        this.algorithmRegistry = (AlgorithmRegistry)Constraint.isNotNull((Object)registry, (String)"AlgorithmRegistry was null");
    }

    @Nonnull
    public Iterable<SignatureSigningParameters> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        SignatureSigningParameters params = this.resolveSingle(criteria);
        if (params != null) {
            return CollectionSupport.singletonList((Object)params);
        }
        return CollectionSupport.emptyList();
    }

    @Nullable
    public SignatureSigningParameters resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        if (criteria == null) {
            this.log.debug("CriteriaSet was null");
            return null;
        }
        Constraint.isNotNull((Object)((SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class)), (String)"Resolver requires an instance of SignatureSigningConfigurationCriterion");
        Predicate<String> includeExcludePredicate = this.getIncludeExcludePredicate(criteria);
        SignatureSigningParameters params = new SignatureSigningParameters();
        this.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, includeExcludePredicate);
        params.setSignatureReferenceDigestMethod(this.resolveReferenceDigestMethod(criteria, includeExcludePredicate));
        params.setSignatureReferenceCanonicalizationAlgorithm(this.resolveReferenceCanonicalizationAlgorithm(criteria));
        params.setSignatureCanonicalizationAlgorithm(this.resolveCanonicalizationAlgorithm(criteria));
        Credential signingCred = params.getSigningCredential();
        String alg = params.getSignatureAlgorithm();
        if (signingCred != null && alg != null) {
            params.setKeyInfoGenerator(this.resolveKeyInfoGenerator(criteria, signingCred));
            params.setSignatureHMACOutputLength(this.resolveHMACOutputLength(criteria, signingCred, alg));
        }
        if (this.validate(params)) {
            this.logResult(params);
            return params;
        }
        return null;
    }

    protected void logResult(@Nonnull SignatureSigningParameters params) {
        if (this.log.isDebugEnabled()) {
            Key signingKey;
            this.log.debug("Resolved SignatureSigningParameters:");
            Credential signingCred = params.getSigningCredential();
            Key key = signingKey = signingCred != null ? CredentialSupport.extractSigningKey((Credential)signingCred) : null;
            if (signingKey != null) {
                this.log.debug("\tSigning credential with key algorithm: {}", (Object)signingKey.getAlgorithm());
            } else {
                this.log.debug("\tSigning credential: null");
            }
            this.log.debug("\tSignature algorithm URI: {}", (Object)params.getSignatureAlgorithm());
            KeyInfoGenerator generator = params.getKeyInfoGenerator();
            this.log.debug("\tSignature KeyInfoGenerator: {}", (Object)(generator != null ? generator.getClass().getName() : "null"));
            this.log.debug("\tReference digest method algorithm URI: {}", (Object)params.getSignatureReferenceDigestMethod());
            this.log.debug("\tReference canonicalization algorithm URI: {}", (Object)params.getSignatureReferenceCanonicalizationAlgorithm());
            this.log.debug("\tCanonicalization algorithm URI: {}", (Object)params.getSignatureCanonicalizationAlgorithm());
            this.log.debug("\tHMAC output length: {}", (Object)params.getSignatureHMACOutputLength());
        }
    }

    protected boolean validate(@Nonnull SignatureSigningParameters params) {
        if (params.getSigningCredential() == null) {
            this.log.warn("Validation failure: Unable to resolve signing credential");
            return false;
        }
        if (params.getSignatureAlgorithm() == null) {
            this.log.warn("Validation failure: Unable to resolve signing algorithm URI");
            return false;
        }
        if (params.getSignatureCanonicalizationAlgorithm() == null) {
            this.log.warn("Validation failure: Unable to resolve signing canonicalization algorithm URI");
            return false;
        }
        if (params.getSignatureReferenceDigestMethod() == null) {
            this.log.warn("Validation failure: Unable to resolve reference digest algorithm URI");
            return false;
        }
        return true;
    }

    @Nonnull
    protected Predicate<String> getIncludeExcludePredicate(@Nonnull CriteriaSet criteria) {
        SignatureSigningConfigurationCriterion criterion = (SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class);
        assert (criterion != null);
        return this.resolveIncludeExcludePredicate(criteria, criterion.getConfigurations());
    }

    protected void resolveAndPopulateCredentialAndSignatureAlgorithm(@Nonnull SignatureSigningParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        List<Credential> credentials = this.getEffectiveSigningCredentials(criteria);
        List<String> algorithms = this.getEffectiveSignatureAlgorithms(criteria, includeExcludePredicate);
        this.log.trace("Resolved effective signature algorithms: {}", algorithms);
        for (Credential credential : credentials) {
            assert (credential != null);
            if (this.log.isTraceEnabled()) {
                Key key = CredentialSupport.extractSigningKey((Credential)credential);
                this.log.trace("Evaluating credential of type: {}", (Object)(key != null ? key.getAlgorithm() : "n/a"));
            }
            for (String algorithm : algorithms) {
                assert (algorithm != null);
                this.log.trace("Evaluating credential against algorithm: {}", (Object)algorithm);
                if (this.credentialSupportsAlgorithm(credential, algorithm)) {
                    this.log.trace("Credential passed eval against algorithm: {}", (Object)algorithm);
                    params.setSigningCredential(credential);
                    params.setSignatureAlgorithm(algorithm);
                    return;
                }
                this.log.trace("Credential failed eval against algorithm: {}", (Object)algorithm);
            }
        }
    }

    @Nonnull
    protected Predicate<String> getAlgorithmRuntimeSupportedPredicate() {
        return new AlgorithmRuntimeSupportedPredicate(this.getAlgorithmRegistry());
    }

    protected boolean credentialSupportsAlgorithm(@Nonnull Credential credential, @Nonnull @NotEmpty String algorithm) {
        return AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)this.getAlgorithmRegistry().get(algorithm));
    }

    @Nonnull
    protected List<Credential> getEffectiveSigningCredentials(@Nonnull CriteriaSet criteria) {
        SignatureSigningConfigurationCriterion criterion = (SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class);
        assert (criterion != null);
        ArrayList<Credential> accumulator = new ArrayList<Credential>();
        for (SignatureSigningConfiguration config : criterion.getConfigurations()) {
            accumulator.addAll(config.getSigningCredentials());
        }
        return accumulator;
    }

    @Nonnull
    protected List<String> getEffectiveSignatureAlgorithms(@Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        SignatureSigningConfigurationCriterion criterion = (SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class);
        assert (criterion != null);
        ArrayList<String> accumulator = new ArrayList<String>();
        for (SignatureSigningConfiguration config : criterion.getConfigurations()) {
            config.getSignatureAlgorithms().stream().filter(PredicateSupport.and(this.getAlgorithmRuntimeSupportedPredicate(), includeExcludePredicate)).forEach(accumulator::add);
        }
        return accumulator;
    }

    @Nullable
    protected String resolveReferenceDigestMethod(@Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        SignatureSigningConfigurationCriterion criterion = (SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class);
        assert (criterion != null);
        for (SignatureSigningConfiguration config : criterion.getConfigurations()) {
            for (String digestMethod : config.getSignatureReferenceDigestMethods()) {
                if (!this.getAlgorithmRuntimeSupportedPredicate().test(digestMethod) || !includeExcludePredicate.test(digestMethod)) continue;
                return digestMethod;
            }
        }
        return null;
    }

    @Nullable
    protected String resolveCanonicalizationAlgorithm(@Nonnull CriteriaSet criteria) {
        SignatureSigningConfigurationCriterion criterion = (SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class);
        assert (criterion != null);
        for (SignatureSigningConfiguration config : criterion.getConfigurations()) {
            if (config.getSignatureCanonicalizationAlgorithm() == null) continue;
            return config.getSignatureCanonicalizationAlgorithm();
        }
        return null;
    }

    @Nullable
    protected String resolveReferenceCanonicalizationAlgorithm(@Nonnull CriteriaSet criteria) {
        SignatureSigningConfigurationCriterion criterion = (SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class);
        assert (criterion != null);
        for (SignatureSigningConfiguration config : criterion.getConfigurations()) {
            if (config.getSignatureReferenceCanonicalizationAlgorithm() == null) continue;
            return config.getSignatureReferenceCanonicalizationAlgorithm();
        }
        return null;
    }

    @Nullable
    protected KeyInfoGenerator resolveKeyInfoGenerator(@Nonnull CriteriaSet criteria, @Nonnull Credential signingCredential) {
        KeyInfoGenerationProfileCriterion keyInfoGenCriterion = (KeyInfoGenerationProfileCriterion)criteria.get(KeyInfoGenerationProfileCriterion.class);
        String name = keyInfoGenCriterion != null ? keyInfoGenCriterion.getName() : null;
        SignatureSigningConfigurationCriterion criterion = (SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class);
        assert (criterion != null);
        for (SignatureSigningConfiguration config : criterion.getConfigurations()) {
            KeyInfoGenerator kig = this.lookupKeyInfoGenerator(signingCredential, config.getKeyInfoGeneratorManager(), name);
            if (kig == null) continue;
            return kig;
        }
        return null;
    }

    @Nullable
    protected Integer resolveHMACOutputLength(@Nonnull CriteriaSet criteria, @Nonnull Credential signingCredential, @Nonnull @NotEmpty String algorithmURI) {
        if (AlgorithmSupport.isHMAC((String)algorithmURI)) {
            SignatureSigningConfigurationCriterion criterion = (SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class);
            assert (criterion != null);
            for (SignatureSigningConfiguration config : criterion.getConfigurations()) {
                if (config.getSignatureHMACOutputLength() == null) continue;
                return config.getSignatureHMACOutputLength();
            }
        }
        return null;
    }
}

