/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup.config;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PropertyConfiguration {
    protected String metricName;

    public String getMetricNameGrouping() {
        return this.metricName;
    }

    public static <T extends PropertyConfiguration> T matches(Collection<T> configs, String metricName) {
        for (PropertyConfiguration histoConfig : configs) {
            if (histoConfig.getMetricNameGrouping().contentEquals("*")) {
                return (T)histoConfig;
            }
            Pattern p = Pattern.compile(histoConfig.getMetricNameGrouping());
            Matcher m = p.matcher(metricName.trim());
            if (!m.matches()) continue;
            return (T)histoConfig;
        }
        return null;
    }
}

