/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.util.Iterator;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.WicketTag;

public class MarkupIterator
implements Iterator<MarkupElement> {
    private final IMarkupFragment markup;
    private int index = -1;
    private boolean componentTagOnly;
    private boolean wicketTagOnly;
    private boolean openTagOnly;

    public MarkupIterator(IMarkupFragment markup) {
        if (markup == null) {
            throw new NullPointerException("Parameter 'markup' must not be null");
        }
        this.markup = markup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasNext() {
        ++this.index;
        while (this.index < this.markup.size()) {
            MarkupElement elem = this.markup.get(this.index);
            if ((!this.componentTagOnly || !(elem instanceof ComponentTag)) && (!this.wicketTagOnly || !(elem instanceof WicketTag))) return true;
            if (!this.openTagOnly) return true;
            ComponentTag tag = (ComponentTag)elem;
            if (tag.isOpen()) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    @Override
    public MarkupElement next() {
        return this.markup.get(this.index);
    }

    public ComponentTag nextTag() {
        return (ComponentTag)this.next();
    }

    public WicketTag nextWicketTag() {
        return (WicketTag)this.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("You can not remove markup elements");
    }

    public final void setComponentTagOnly(boolean componentTagOnly) {
        this.componentTagOnly = componentTagOnly;
    }

    public final void setWicketTagOnly(boolean wicketTagOnly) {
        this.wicketTagOnly = wicketTagOnly;
    }

    public final void setOpenTagOnly(boolean openTagOnly) {
        this.openTagOnly = openTagOnly;
    }
}

